package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeSHXEnum implements AreaCodeEnumerable {
    CODE_610000("610000", "陕西省"),
    CODE_610100("610100", "陕西省西安市"),
    CODE_610101("610101", "陕西省西安市市辖区"),
    CODE_610102("610102", "陕西省西安市新城区"),
    CODE_610103("610103", "陕西省西安市碑林区"),
    CODE_610104("610104", "陕西省西安市莲湖区"),
    CODE_610111("610111", "陕西省西安市灞桥区"),
    CODE_610112("610112", "陕西省西安市未央区"),
    CODE_610113("610113", "陕西省西安市雁塔区"),
    CODE_610114("610114", "陕西省西安市阎良区"),
    CODE_610115("610115", "陕西省西安市临潼区"),
    CODE_610121("610121", "陕西省西安市长安县"),
    CODE_610122("610122", "陕西省西安市蓝田县"),
    CODE_610124("610124", "陕西省西安市周至县"),
    CODE_610125("610125", "陕西省西安市户县"),
    CODE_610126("610126", "陕西省西安市高陵县"),
    CODE_610200("610200", "陕西省铜川市"),
    CODE_610201("610201", "陕西省铜川市市辖区"),
    CODE_610202("610202", "陕西省铜川市城区"),
    CODE_610203("610203", "陕西省铜川市郊区"),
    CODE_610221("610221", "陕西省铜川市耀县"),
    CODE_610222("610222", "陕西省铜川市宜君县"),
    CODE_610300("610300", "陕西省宝鸡市"),
    CODE_610301("610301", "陕西省宝鸡市市辖区"),
    CODE_610302("610302", "陕西省宝鸡市渭滨区"),
    CODE_610303("610303", "陕西省宝鸡市金台区"),
    CODE_610321("610321", "陕西省宝鸡市宝鸡县"),
    CODE_610322("610322", "陕西省宝鸡市凤翔县"),
    CODE_610323("610323", "陕西省宝鸡市岐山县"),
    CODE_610324("610324", "陕西省宝鸡市扶风县"),
    CODE_610326("610326", "陕西省宝鸡市眉县"),
    CODE_610327("610327", "陕西省宝鸡市陇县"),
    CODE_610328("610328", "陕西省宝鸡市千阳县"),
    CODE_610329("610329", "陕西省宝鸡市麟游县"),
    CODE_610330("610330", "陕西省宝鸡市凤县"),
    CODE_610331("610331", "陕西省宝鸡市太白县"),
    CODE_610400("610400", "陕西省咸阳市"),
    CODE_610401("610401", "陕西省咸阳市市辖区"),
    CODE_610402("610402", "陕西省咸阳市秦都区"),
    CODE_610403("610403", "陕西省咸阳市杨陵区"),
    CODE_610404("610404", "陕西省咸阳市渭城区"),
    CODE_610422("610422", "陕西省咸阳市三原县"),
    CODE_610423("610423", "陕西省咸阳市泾阳县"),
    CODE_610424("610424", "陕西省咸阳市乾县"),
    CODE_610425("610425", "陕西省咸阳市礼泉县"),
    CODE_610426("610426", "陕西省咸阳市永寿县"),
    CODE_610427("610427", "陕西省咸阳市彬县"),
    CODE_610428("610428", "陕西省咸阳市长武县"),
    CODE_610429("610429", "陕西省咸阳市旬邑县"),
    CODE_610430("610430", "陕西省咸阳市淳化县"),
    CODE_610431("610431", "陕西省咸阳市武功县"),
    CODE_610481("610481", "陕西省咸阳市兴平市"),
    CODE_610500("610500", "陕西省渭南市"),
    CODE_610501("610501", "陕西省渭南市市辖区"),
    CODE_610502("610502", "陕西省渭南市临渭区"),
    CODE_610521("610521", "陕西省渭南市华县"),
    CODE_610522("610522", "陕西省渭南市潼关县"),
    CODE_610523("610523", "陕西省渭南市大荔县"),
    CODE_610524("610524", "陕西省渭南市合阳县"),
    CODE_610525("610525", "陕西省渭南市澄城县"),
    CODE_610526("610526", "陕西省渭南市蒲城县"),
    CODE_610527("610527", "陕西省渭南市白水县"),
    CODE_610528("610528", "陕西省渭南市富平县"),
    CODE_610581("610581", "陕西省渭南市韩城市"),
    CODE_610582("610582", "陕西省渭南市华阴市"),
    CODE_610600("610600", "陕西省延安市"),
    CODE_610601("610601", "陕西省延安市市辖区"),
    CODE_610602("610602", "陕西省延安市宝塔区"),
    CODE_610621("610621", "陕西省延安市延长县"),
    CODE_610622("610622", "陕西省延安市延川县"),
    CODE_610623("610623", "陕西省延安市子长县"),
    CODE_610624("610624", "陕西省延安市安塞县"),
    CODE_610625("610625", "陕西省延安市志丹县"),
    CODE_610626("610626", "陕西省延安市吴旗县"),
    CODE_610627("610627", "陕西省延安市甘泉县"),
    CODE_610628("610628", "陕西省延安市富县"),
    CODE_610629("610629", "陕西省延安市洛川县"),
    CODE_610630("610630", "陕西省延安市宜川县"),
    CODE_610631("610631", "陕西省延安市黄龙县"),
    CODE_610632("610632", "陕西省延安市黄陵县"),
    CODE_610700("610700", "陕西省汉中市"),
    CODE_610701("610701", "陕西省汉中市市辖区"),
    CODE_610702("610702", "陕西省汉中市汉台区"),
    CODE_610721("610721", "陕西省汉中市南郑县"),
    CODE_610722("610722", "陕西省汉中市城固县"),
    CODE_610723("610723", "陕西省汉中市洋县"),
    CODE_610724("610724", "陕西省汉中市西乡县"),
    CODE_610725("610725", "陕西省汉中市勉县"),
    CODE_610726("610726", "陕西省汉中市宁强县"),
    CODE_610727("610727", "陕西省汉中市略阳县"),
    CODE_610728("610728", "陕西省汉中市镇巴县"),
    CODE_610729("610729", "陕西省汉中市留坝县"),
    CODE_610730("610730", "陕西省汉中市佛坪县"),
    CODE_612400("612400", "陕西省安康地区"),
    CODE_612401("612401", "陕西省安康地区安康市"),
    CODE_612422("612422", "陕西省安康地区汉阴县"),
    CODE_612423("612423", "陕西省安康地区石泉县"),
    CODE_612424("612424", "陕西省安康地区宁陕县"),
    CODE_612425("612425", "陕西省安康地区紫阳县"),
    CODE_612426("612426", "陕西省安康地区岚皋县"),
    CODE_612427("612427", "陕西省安康地区平利县"),
    CODE_612428("612428", "陕西省安康地区镇坪县"),
    CODE_612429("612429", "陕西省安康地区旬阳县"),
    CODE_612430("612430", "陕西省安康地区白河县"),
    CODE_612500("612500", "陕西省商洛地区"),
    CODE_612501("612501", "陕西省商洛地区商州市"),
    CODE_612522("612522", "陕西省商洛地区洛南县"),
    CODE_612523("612523", "陕西省商洛地区丹凤县"),
    CODE_612524("612524", "陕西省商洛地区商南县"),
    CODE_612525("612525", "陕西省商洛地区山阳县"),
    CODE_612526("612526", "陕西省商洛地区镇安县"),
    CODE_612527("612527", "陕西省商洛地区柞水县"),
    CODE_612700("612700", "陕西省榆林地区"),
    CODE_612701("612701", "陕西省榆林地区榆林市"),
    CODE_612722("612722", "陕西省榆林地区神木县"),
    CODE_612723("612723", "陕西省榆林地区府谷县"),
    CODE_612724("612724", "陕西省榆林地区横山县"),
    CODE_612725("612725", "陕西省榆林地区靖边县"),
    CODE_612726("612726", "陕西省榆林地区定边县"),
    CODE_612727("612727", "陕西省榆林地区绥德县"),
    CODE_612728("612728", "陕西省榆林地区米脂县"),
    CODE_612729("612729", "陕西省榆林地区佳县"),
    CODE_612730("612730", "陕西省榆林地区吴堡县"),
    CODE_612731("612731", "陕西省榆林地区清涧县"),
    CODE_612732("612732", "陕西省榆林地区子洲县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeSHXEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
