package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeSXEnum implements AreaCodeEnumerable {
    CODE_140000("140000", "山西省"),
    CODE_140100("140100", "山西省太原市"),
    CODE_140101("140101", "山西省太原市市辖区"),
    CODE_140105("140105", "山西省太原市小店区"),
    CODE_140106("140106", "山西省太原市迎泽区"),
    CODE_140107("140107", "山西省太原市杏花岭区"),
    CODE_140108("140108", "山西省太原市尖草坪区"),
    CODE_140109("140109", "山西省太原市万柏林区"),
    CODE_140110("140110", "山西省太原市晋源区"),
    CODE_140121("140121", "山西省太原市清徐县"),
    CODE_140122("140122", "山西省太原市阳曲县"),
    CODE_140123("140123", "山西省太原市娄烦县"),
    CODE_140181("140181", "山西省太原市古交市"),
    CODE_140200("140200", "山西省大同市"),
    CODE_140201("140201", "山西省大同市市辖区"),
    CODE_140202("140202", "山西省大同市城区"),
    CODE_140203("140203", "山西省大同市矿区"),
    CODE_140211("140211", "山西省大同市南郊区"),
    CODE_140212("140212", "山西省大同市新荣区"),
    CODE_140221("140221", "山西省大同市阳高县"),
    CODE_140222("140222", "山西省大同市天镇县"),
    CODE_140223("140223", "山西省大同市广灵县"),
    CODE_140224("140224", "山西省大同市灵丘县"),
    CODE_140225("140225", "山西省大同市浑源县"),
    CODE_140226("140226", "山西省大同市左云县"),
    CODE_140227("140227", "山西省大同市大同县"),
    CODE_140300("140300", "山西省阳泉市"),
    CODE_140301("140301", "山西省阳泉市市辖区"),
    CODE_140302("140302", "山西省阳泉市城区"),
    CODE_140303("140303", "山西省阳泉市矿区"),
    CODE_140311("140311", "山西省阳泉市郊区"),
    CODE_140321("140321", "山西省阳泉市平定县"),
    CODE_140322("140322", "山西省阳泉市盂县"),
    CODE_140400("140400", "山西省长治市"),
    CODE_140401("140401", "山西省长治市市辖区"),
    CODE_140402("140402", "山西省长治市城区"),
    CODE_140411("140411", "山西省长治市郊区"),
    CODE_140421("140421", "山西省长治市长治县"),
    CODE_140423("140423", "山西省长治市襄垣县"),
    CODE_140424("140424", "山西省长治市屯留县"),
    CODE_140425("140425", "山西省长治市平顺县"),
    CODE_140426("140426", "山西省长治市黎城县"),
    CODE_140427("140427", "山西省长治市壶关县"),
    CODE_140428("140428", "山西省长治市长子县"),
    CODE_140429("140429", "山西省长治市武乡县"),
    CODE_140430("140430", "山西省长治市沁县"),
    CODE_140431("140431", "山西省长治市沁源县"),
    CODE_140481("140481", "山西省长治市潞城市"),
    CODE_140500("140500", "山西省晋城市"),
    CODE_140501("140501", "山西省晋城市市辖区"),
    CODE_140502("140502", "山西省晋城市城区"),
    CODE_140521("140521", "山西省晋城市沁水县"),
    CODE_140522("140522", "山西省晋城市阳城县"),
    CODE_140524("140524", "山西省晋城市陵川县"),
    CODE_140525("140525", "山西省晋城市泽州县"),
    CODE_140581("140581", "山西省晋城市高平市"),
    CODE_140600("140600", "山西省晋城市朔州市"),
    CODE_140601("140601", "山西省晋城市市辖区"),
    CODE_140602("140602", "山西省晋城市朔城区"),
    CODE_140603("140603", "山西省晋城市平鲁区"),
    CODE_140621("140621", "山西省晋城市山阴县"),
    CODE_140622("140622", "山西省晋城市应县"),
    CODE_140623("140623", "山西省晋城市右玉县"),
    CODE_140624("140624", "山西省晋城市怀仁县"),
    CODE_142200("142200", "山西省忻州地区"),
    CODE_142201("142201", "山西省忻州地区忻州市"),
    CODE_142202("142202", "山西省忻州地区原平市"),
    CODE_142222("142222", "山西省忻州地区定襄县"),
    CODE_142223("142223", "山西省忻州地区五台县"),
    CODE_142225("142225", "山西省忻州地区代县"),
    CODE_142226("142226", "山西省忻州地区繁峙县"),
    CODE_142227("142227", "山西省忻州地区宁武县"),
    CODE_142228("142228", "山西省忻州地区静乐县"),
    CODE_142229("142229", "山西省忻州地区神池县"),
    CODE_142230("142230", "山西省忻州地区五寨县"),
    CODE_142231("142231", "山西省忻州地区岢岚县"),
    CODE_142232("142232", "山西省忻州地区河曲县"),
    CODE_142233("142233", "山西省忻州地区保德县"),
    CODE_142234("142234", "山西省忻州地区偏关县"),
    CODE_142300("142300", "山西省忻州地区吕梁地区"),
    CODE_142301("142301", "山西省忻州地区孝义市"),
    CODE_142302("142302", "山西省忻州地区离石市"),
    CODE_142303("142303", "山西省忻州地区汾阳市"),
    CODE_142322("142322", "山西省忻州地区文水县"),
    CODE_142323("142323", "山西省忻州地区交城县"),
    CODE_142325("142325", "山西省忻州地区兴县"),
    CODE_142326("142326", "山西省忻州地区临县"),
    CODE_142327("142327", "山西省忻州地区柳林县"),
    CODE_142328("142328", "山西省忻州地区石楼县"),
    CODE_142329("142329", "山西省忻州地区岚县"),
    CODE_142330("142330", "山西省忻州地区方山县"),
    CODE_142332("142332", "山西省忻州地区中阳县"),
    CODE_142333("142333", "山西省忻州地区交口县"),
    CODE_142400("142400", "山西省晋中地区"),
    CODE_142401("142401", "山西省晋中地区榆次市"),
    CODE_142402("142402", "山西省晋中地区介休市"),
    CODE_142421("142421", "山西省晋中地区榆社县"),
    CODE_142422("142422", "山西省晋中地区左权县"),
    CODE_142423("142423", "山西省晋中地区和顺县"),
    CODE_142424("142424", "山西省晋中地区昔阳县"),
    CODE_142427("142427", "山西省晋中地区寿阳县"),
    CODE_142429("142429", "山西省晋中地区太谷县"),
    CODE_142430("142430", "山西省晋中地区祁县"),
    CODE_142431("142431", "山西省晋中地区平遥县"),
    CODE_142433("142433", "山西省晋中地区灵石县"),
    CODE_142600("142600", "山西省临汾地区"),
    CODE_142601("142601", "山西省临汾地区临汾市"),
    CODE_142602("142602", "山西省临汾地区侯马市"),
    CODE_142603("142603", "山西省临汾地区霍州市"),
    CODE_142621("142621", "山西省临汾地区曲沃县"),
    CODE_142622("142622", "山西省临汾地区翼城县"),
    CODE_142623("142623", "山西省临汾地区襄汾县"),
    CODE_142625("142625", "山西省临汾地区洪洞县"),
    CODE_142627("142627", "山西省临汾地区古县"),
    CODE_142628("142628", "山西省临汾地区安泽县"),
    CODE_142629("142629", "山西省临汾地区浮山县"),
    CODE_142630("142630", "山西省临汾地区吉县"),
    CODE_142631("142631", "山西省临汾地区乡宁县"),
    CODE_142632("142632", "山西省临汾地区蒲县"),
    CODE_142633("142633", "山西省临汾地区大宁县"),
    CODE_142634("142634", "山西省临汾地区永和县"),
    CODE_142635("142635", "山西省临汾地区隰县"),
    CODE_142636("142636", "山西省临汾地区汾西县"),
    CODE_142700("142700", "山西省运城地区"),
    CODE_142701("142701", "山西省运城地区运城市"),
    CODE_142702("142702", "山西省运城地区永济市"),
    CODE_142703("142703", "山西省运城地区河津市"),
    CODE_142723("142723", "山西省运城地区芮城县"),
    CODE_142724("142724", "山西省运城地区临猗县"),
    CODE_142725("142725", "山西省运城地区万荣县"),
    CODE_142726("142726", "山西省运城地区新绛县"),
    CODE_142727("142727", "山西省运城地区稷山县"),
    CODE_142729("142729", "山西省运城地区闻喜县"),
    CODE_142730("142730", "山西省运城地区夏县"),
    CODE_142731("142731", "山西省运城地区绛县"),
    CODE_142732("142732", "山西省运城地区平陆县"),
    CODE_142733("142733", "山西省运城地区垣曲县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeSXEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
