package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeYNEnum implements AreaCodeEnumerable {
    CODE_530000("530000", "云南省"),
    CODE_530100("530100", "云南省昆明市"),
    CODE_530101("530101", "云南省昆明市市辖区"),
    CODE_530102("530102", "云南省昆明市五华区"),
    CODE_530103("530103", "云南省昆明市盘龙区"),
    CODE_530111("530111", "云南省昆明市官渡区"),
    CODE_530112("530112", "云南省昆明市西山区"),
    CODE_530113("530113", "云南省昆明市东川区"),
    CODE_530121("530121", "云南省昆明市呈贡县"),
    CODE_530122("530122", "云南省昆明市晋宁县"),
    CODE_530124("530124", "云南省昆明市富民县"),
    CODE_530125("530125", "云南省昆明市宜良县"),
    CODE_530126("530126", "云南省昆明市石林彝族自治县"),
    CODE_530127("530127", "云南省昆明市嵩明县"),
    CODE_530128("530128", "云南省昆明市禄劝彝族苗族自治县"),
    CODE_530129("530129", "云南省昆明市寻甸回族彝族自治县"),
    CODE_530181("530181", "云南省昆明市安宁市"),
    CODE_530300("530300", "云南省曲靖市"),
    CODE_530301("530301", "云南省曲靖市市辖区"),
    CODE_530302("530302", "云南省曲靖市麒麟区"),
    CODE_530321("530321", "云南省曲靖市马龙县"),
    CODE_530322("530322", "云南省曲靖市陆良县"),
    CODE_530323("530323", "云南省曲靖市师宗县"),
    CODE_530324("530324", "云南省曲靖市罗平县"),
    CODE_530325("530325", "云南省曲靖市富源县"),
    CODE_530326("530326", "云南省曲靖市会泽县"),
    CODE_530328("530328", "云南省曲靖市沾益县"),
    CODE_530381("530381", "云南省曲靖市宣威市"),
    CODE_530400("530400", "云南省玉溪市"),
    CODE_530401("530401", "云南省玉溪市市辖区"),
    CODE_530402("530402", "云南省玉溪市红塔区"),
    CODE_530421("530421", "云南省玉溪市江川县"),
    CODE_530422("530422", "云南省玉溪市澄江县"),
    CODE_530423("530423", "云南省玉溪市通海县"),
    CODE_530424("530424", "云南省玉溪市华宁县"),
    CODE_530425("530425", "云南省玉溪市易门县"),
    CODE_530426("530426", "云南省玉溪市峨山彝族自治县"),
    CODE_530427("530427", "云南省玉溪市新平彝族傣族自治县"),
    CODE_530428("530428", "云南省玉溪市元江哈尼族彝族傣族自治县"),
    CODE_532100("532100", "云南省昭通地区"),
    CODE_532101("532101", "云南省昭通地区昭通市"),
    CODE_532122("532122", "云南省昭通地区鲁甸县"),
    CODE_532123("532123", "云南省昭通地区巧家县"),
    CODE_532124("532124", "云南省昭通地区盐津县"),
    CODE_532125("532125", "云南省昭通地区大关县"),
    CODE_532126("532126", "云南省昭通地区永善县"),
    CODE_532127("532127", "云南省昭通地区绥江县"),
    CODE_532128("532128", "云南省昭通地区镇雄县"),
    CODE_532129("532129", "云南省昭通地区彝良县"),
    CODE_532130("532130", "云南省昭通地区威信县"),
    CODE_532131("532131", "云南省昭通地区水富县"),
    CODE_532300("532300", "云南省楚雄彝族自治州"),
    CODE_532301("532301", "云南省楚雄彝族自治州楚雄市"),
    CODE_532322("532322", "云南省楚雄彝族自治州双柏县"),
    CODE_532323("532323", "云南省楚雄彝族自治州牟定县"),
    CODE_532324("532324", "云南省楚雄彝族自治州南华县"),
    CODE_532325("532325", "云南省楚雄彝族自治州姚安县"),
    CODE_532326("532326", "云南省楚雄彝族自治州大姚县"),
    CODE_532327("532327", "云南省楚雄彝族自治州永仁县"),
    CODE_532328("532328", "云南省楚雄彝族自治州元谋县"),
    CODE_532329("532329", "云南省楚雄彝族自治州武定县"),
    CODE_532331("532331", "云南省楚雄彝族自治州禄丰县"),
    CODE_532500("532500", "云南省红河哈尼族彝族自治州"),
    CODE_532501("532501", "云南省红河哈尼族彝族自治州个旧市"),
    CODE_532502("532502", "云南省红河哈尼族彝族自治州开远市"),
    CODE_532522("532522", "云南省红河哈尼族彝族自治州蒙自县"),
    CODE_532523("532523", "云南省红河哈尼族彝族自治州屏边苗族自治县"),
    CODE_532524("532524", "云南省红河哈尼族彝族自治州建水县"),
    CODE_532525("532525", "云南省红河哈尼族彝族自治州石屏县"),
    CODE_532526("532526", "云南省红河哈尼族彝族自治州弥勒县"),
    CODE_532527("532527", "云南省红河哈尼族彝族自治州泸西县"),
    CODE_532528("532528", "云南省红河哈尼族彝族自治州元阳县"),
    CODE_532529("532529", "云南省红河哈尼族彝族自治州红河县"),
    CODE_532530("532530", "云南省红河哈尼族彝族自治州金平苗族瑶族傣族自治县"),
    CODE_532531("532531", "云南省红河哈尼族彝族自治州绿春县"),
    CODE_532532("532532", "云南省红河哈尼族彝族自治州河口瑶族自治县"),
    CODE_532600("532600", "云南省文山壮族苗族自治州"),
    CODE_532621("532621", "云南省文山壮族苗族自治州文山县"),
    CODE_532622("532622", "云南省文山壮族苗族自治州砚山县"),
    CODE_532623("532623", "云南省文山壮族苗族自治州西畴县"),
    CODE_532624("532624", "云南省文山壮族苗族自治州麻栗坡县"),
    CODE_532625("532625", "云南省文山壮族苗族自治州马关县"),
    CODE_532626("532626", "云南省文山壮族苗族自治州丘北县"),
    CODE_532627("532627", "云南省文山壮族苗族自治州广南县"),
    CODE_532628("532628", "云南省文山壮族苗族自治州富宁县"),
    CODE_532700("532700", "云南省思茅地区"),
    CODE_532701("532701", "云南省思茅地区思茅市"),
    CODE_532722("532722", "云南省思茅地区普洱哈尼族彝族自治县"),
    CODE_532723("532723", "云南省思茅地区墨江哈尼族自治县"),
    CODE_532724("532724", "云南省思茅地区景东彝族自治县"),
    CODE_532725("532725", "云南省思茅地区景谷傣族彝族自治县"),
    CODE_532726("532726", "云南省思茅地区镇沅彝族哈尼族拉祜族自治县"),
    CODE_532727("532727", "云南省思茅地区江城哈尼族彝族自治县"),
    CODE_532728("532728", "云南省思茅地区孟连傣族拉祜族佤族自治县"),
    CODE_532729("532729", "云南省思茅地区澜沧拉祜族自治县"),
    CODE_532730("532730", "云南省思茅地区西盟佤族自治县"),
    CODE_532800("532800", "云南省西双版纳傣族自治州"),
    CODE_532801("532801", "云南省西双版纳傣族自治州景洪市"),
    CODE_532822("532822", "云南省西双版纳傣族自治州勐海县"),
    CODE_532823("532823", "云南省西双版纳傣族自治州勐腊县"),
    CODE_532900("532900", "云南省大理白族自治州"),
    CODE_532901("532901", "云南省大理白族自治州大理市"),
    CODE_532922("532922", "云南省大理白族自治州漾濞彝族自治县"),
    CODE_532923("532923", "云南省大理白族自治州祥云县"),
    CODE_532924("532924", "云南省大理白族自治州宾川县"),
    CODE_532925("532925", "云南省大理白族自治州弥渡县"),
    CODE_532926("532926", "云南省大理白族自治州南涧彝族自治县"),
    CODE_532927("532927", "云南省大理白族自治州巍山彝族回族自治县"),
    CODE_532928("532928", "云南省大理白族自治州永平县"),
    CODE_532929("532929", "云南省大理白族自治州云龙县"),
    CODE_532930("532930", "云南省大理白族自治州洱源县"),
    CODE_532931("532931", "云南省大理白族自治州剑川县"),
    CODE_532932("532932", "云南省大理白族自治州鹤庆县"),
    CODE_533000("533000", "云南省保山地区"),
    CODE_533001("533001", "云南省保山地区保山市"),
    CODE_533022("533022", "云南省保山地区施甸县"),
    CODE_533023("533023", "云南省保山地区腾冲县"),
    CODE_533024("533024", "云南省保山地区龙陵县"),
    CODE_533025("533025", "云南省保山地区昌宁县"),
    CODE_533100("533100", "云南省德宏傣族景颇族自治州"),
    CODE_533101("533101", "云南省德宏傣族景颇族自治州畹町市"),
    CODE_533102("533102", "云南省德宏傣族景颇族自治州瑞丽市"),
    CODE_533103("533103", "云南省德宏傣族景颇族自治州潞西市"),
    CODE_533122("533122", "云南省德宏傣族景颇族自治州梁河县"),
    CODE_533123("533123", "云南省德宏傣族景颇族自治州盈江县"),
    CODE_533124("533124", "云南省德宏傣族景颇族自治州陇川县"),
    CODE_533200("533200", "云南省丽江地区"),
    CODE_533221("533221", "云南省丽江地区丽江纳西族自治县"),
    CODE_533222("533222", "云南省丽江地区永胜县"),
    CODE_533223("533223", "云南省丽江地区华坪县"),
    CODE_533224("533224", "云南省丽江地区宁蒗彝族自治县"),
    CODE_533300("533300", "云南省怒江傈僳族自治州"),
    CODE_533321("533321", "云南省怒江傈僳族自治州泸水县"),
    CODE_533323("533323", "云南省怒江傈僳族自治州福贡县"),
    CODE_533324("533324", "云南省怒江傈僳族自治州贡山独龙族怒族自治县"),
    CODE_533325("533325", "云南省怒江傈僳族自治州兰坪白族普米族自治县"),
    CODE_533400("533400", "云南省迪庆藏族自治州"),
    CODE_533421("533421", "云南省迪庆藏族自治州中甸县"),
    CODE_533422("533422", "云南省迪庆藏族自治州德钦县"),
    CODE_533423("533423", "云南省迪庆藏族自治州维西傈僳族自治县"),
    CODE_533500("533500", "云南省临沧地区"),
    CODE_533521("533521", "云南省临沧地区临沧县"),
    CODE_533522("533522", "云南省临沧地区凤庆县"),
    CODE_533523("533523", "云南省临沧地区云县"),
    CODE_533524("533524", "云南省临沧地区永德县"),
    CODE_533525("533525", "云南省临沧地区镇康县"),
    CODE_533526("533526", "云南省临沧地区双江拉祜族佤族布朗族傣族自治县"),
    CODE_533527("533527", "云南省临沧地区耿马傣族佤族自治县"),
    CODE_533528("533528", "云南省临沧地区沧源佤族自治县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeYNEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
