package com.qiho.center.api.enums;

import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/9/4 10:26 上午
 */
@Getter
@AllArgsConstructor
public enum KuaiDi100LogisticsOrderConditionEnum {

    INTERCEPT("2", "Y01", "快递拦截"),
    REFUSED_NOT_RETURN("2", "Y05", "已拒签未退回"),
    NOT_REACH_CUSTOMER("2", "Y04", "联系不上用户"),
    GOODS_ABNORMAL("2", "Y02", "货物异常"),
    DETENTION_SHIPMENT("2", "Y03", "滞留件"),
    SINCE_THE_CONTAINER("5", "ZT01", "放入自提柜"),
    OTHER_SIGN("3", "ZT01", "签收成功，他人签收");


    private String state;

    private String condition;

    private String desc;

    public static KuaiDi100LogisticsOrderConditionEnum getByStateAndCondition(String state, String condition) {
        if (StringUtils.isBlank(state) || StringUtils.isBlank(condition)) {
            return null;
        }
        Map<String, KuaiDi100LogisticsOrderConditionEnum> orderConditionMap
            = Maps.uniqueIndex(Arrays.asList(KuaiDi100LogisticsOrderConditionEnum.values()),
            input -> input.getState() + "#" + input.getCondition());
        return orderConditionMap.get(state + "#" + condition);

    }
}
