/**
 * Project Name:qiho-center-api File Name:OrderStatusEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年6月2日下午1:52:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

/**
 * ClassName:OrderInfoUpdateTypeEnum <br/>
 * 更新订单信息类型枚举. <br/>
 * Date: 2018-06-14 <br/>
 *
 * @author jiafeng.geng
 */
public enum OrderInfoUpdateTypeEnum {

    BULL_POSITION(1, "BULL_POSITION", "买家信息"),
    ITEM(2, "ITEM", "商品信息");

    private int code;
    private String msg;
    private String desc;

    private OrderInfoUpdateTypeEnum(int code, String msg, String desc) {
        this.code = code;
        this.msg = msg;
        this.desc = desc;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static OrderInfoUpdateTypeEnum getByCode(int code) {
        for (OrderInfoUpdateTypeEnum enumVal : OrderInfoUpdateTypeEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return msg
     */
    public String getMsg() {
        return msg;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
