package com.qiho.center.api.enums.log;

/**
 * @author Wangpf
 * @description 在线支付日志监听 日志打印环节区分
 * @date 2021/3/17 11:00 上午
 */
public enum RequestTypeEnum {

    FRONT_CHECK(1, "前端信息校验"),

    ORDER_EVENT(2, "获取订单信息事件"),

    REDIRECT_THIRD_PARTY_PAY(3, "跳转第三方支付页面"),

    ORDER_RULE_CHECK(4, "下单规则校验"),

    CALL_THIRD_PARTY_PAY(5, "调用第三方支付接口"),

    THIRD_PARTY_PAY_CALL_BACK(6, "第三方支付接口回调推啊"),

    ORDER_SUCCESS_REDIRECT(7, "下单成功页跳转");

    /**
     * 业务环境类型
     */
    private final int requestType;

    private final String desc;

    RequestTypeEnum(int requestType, String desc) {
        this.requestType = requestType;
        this.desc = desc;
    }

    public int getRequestType() {
        return requestType;
    }

    public String getDesc() {
        return desc;
    }
}
