package com.qiho.center.api.remoteservice.ordertmp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.ordertmp.OrderTmpDetailDto;
import com.qiho.center.api.params.ordertmp.OrderTmpPageParam;

/** 临时订单远程接口
 * @author chensong
 * @create 2018-05-17 11:59
 **/
@AdvancedFeignClient
public interface RemoteOrderTmpService {

    /**
     * 提交临时订单
     * @param orderDeatil
     * @return orderId
     */
    String submitOrderTmp(OrderTmpDetailDto orderDeatil);

    /**
     * 提交临时订单 -- 活动入口
     * @param orderDeatil
     * @return orderId
     */
    String activitySubmitOrderTmp(OrderTmpDetailDto orderDeatil);

    /**
     * 分页查询临时订单
     * @param pageParam
     * @return
     */
    PagenationDto<OrderTmpDetailDto> queryOrderTmpPage(OrderTmpPageParam pageParam);

    /**
     * 将临时订单变成有效
     * @param orderId
     * @return
     */
    ResultDto<Boolean> toValid(String orderId);


    /**
     * 将临时订单变成有效
     * @param orderId
     * @return
     */
    ResultDto<Boolean> toValidWithOperator(String orderId, Integer operatorType, String operator);

    /**
     * 根据orderId 获取临时订单详情
     * @param orderId
     * @return
     */
    OrderTmpDetailDto findByOrderId(String orderId);

    /**
     * 分页查询统计
     * @param pageParam
     * @return
     */
    int countPageQuery(OrderTmpPageParam pageParam);
}
