package com.qiho.center.api.remoteservice.wechat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.config.WechatItemConfigDto;

/**
 * 微信商品服务RPC接口
 *
 * @author chensong
 * @create 2018-09-05
 */
@AdvancedFeignClient
public interface RemoteWechatItemService {

    /**
     * 获取商品的用于微信小程序的配置
     * @param itemId
     * @return
     */
    WechatItemConfigDto getWechatItemConfig(Long itemId);

    /**
     * 保存微信商品配置
     * @param itemId
     * @param itemConfig
     * @return
     */
    ResultDto<Boolean> saveWechatItemConfig(Long itemId, WechatItemConfigDto itemConfig);

}
