package com.qiho.center.api.constant;

/**
 *  订单备注信息的常量
 *  统一维护订单的备注
 *
 * @author chensong
 * @create 2018-08-15
 */
public class OrderRemarkConstant {

    private OrderRemarkConstant(){}

    /** 管理员后台审核不通过或者取消发货 */
    public static final String MANAGER_AUDIT_REJECTION = "用户取消订单";

    /** 用户主动取消订单 */
    public static final String USER_CANCEL_ORDER = "主动取消";

    /** 商家审核不通过 */
    public static final String MERCHANT_AUDIT_REJECTION = "商家审核不通过";

    /** 商家后台取消发货 */
    public static final String MERCHANT_CANCEL_SNED = "商家取消发货";

    /** 踢单规则关闭订单 */
    public static final String SHOTORDER_STRATEGY_REJECTION = "风控规则审核不通过";

    /** 订单已发货-在途  */
    public static final String ORDER_DELIVERED_UNDER_WAY = "在途";

    /** 订单已发货-接单 */
    public static final String ORDER_DELIVERED_ACCEPT = "接单";

    /** 订单已发货-派件 */
    public static final String ORDER_DELIVERED_SENT_SCAN = "派件";

    /** 订单已发货-拒签 */
    public static final String ORDER_DELIVERED_REJECTED = "拒签";

    /** 订单已发货-签收失败 */
    public static final String ORDER_DELIVERED_FAILED = "签收失败";

    /** 订单已发货-签收成功 */
    public static final String ORDER_DELIVERED_SUCCESS= "签收成功";

    /** 订单已发货-退件成功 */
    public static final String ORDER_DELIVERED_RETURN = "退件成功";

    /** 订单已发货-退回中 */
    public static final String ORDER_DELIVERED_SEND_BACK = "退回中";

    /** 订单已发货-签收异常 */
    public static final String ORDER_DELIVERED_ABNORMAL = "签收异常";

    /** 签收失败超时任务关闭订单 */
    public static final String SIGN_FAILED_TIME_OUT_TASK_CLOSE = "物流子订单状态长期未更新，自动关闭";


}
