/**
 * Project Name:qiho-center-api File Name:ItemSimpleDto.java Package Name:com.qiho.center.api.dto
 * Date:2017年6月3日下午3:37:18 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import com.qiho.center.api.enums.DeliveryEnum;

/**
 * ClassName:ItemSimpleDto <br/>
 * Date: 2017年6月3日 下午3:37:18 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ItemSimpleDto extends BaseDto {

    /**
     */
    private static final long serialVersionUID = 1842242902991882498L;

    /** 商品ID */
    private Long              id;

    /** 一级类目ID */
    private Long              topCategoryId;

    /** 商品名称 */
    private String            itemName;

    /** 商品简称 */
    private String            itemShortName;

    /** 商品货号 */
    private String            itemNo;

    /** 商品状态，ON-上架/OFF-下架 */
    private String            itemStatus;

    /** 价格文案 */
    private String            priceText;

    /** 是否删除 */
    private Boolean           deleted;

    /** 发货方式 {@link DeliveryEnum} */
    private String            delivery;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * topCategoryId.
     *
     * @return the topCategoryId
     */
    public Long getTopCategoryId() {
        return topCategoryId;
    }

    /**
     * topCategoryId.
     *
     * @param topCategoryId the topCategoryId to set
     */
    public void setTopCategoryId(Long topCategoryId) {
        this.topCategoryId = topCategoryId;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * itemShortName.
     *
     * @return the itemShortName
     */
    public String getItemShortName() {
        return itemShortName;
    }

    /**
     * itemShortName.
     *
     * @param itemShortName the itemShortName to set
     */
    public void setItemShortName(String itemShortName) {
        this.itemShortName = itemShortName;
    }

    /**
     * itemNo.
     *
     * @return the itemNo
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * itemNo.
     *
     * @param itemNo the itemNo to set
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * itemStatus.
     *
     * @return the itemStatus
     */
    public String getItemStatus() {
        return itemStatus;
    }

    /**
     * itemStatus.
     *
     * @param itemStatus the itemStatus to set
     */
    public void setItemStatus(String itemStatus) {
        this.itemStatus = itemStatus;
    }

    /**
     * priceText.
     *
     * @return the priceText
     */
    public String getPriceText() {
        return priceText;
    }

    /**
     * priceText.
     *
     * @param priceText the priceText to set
     */
    public void setPriceText(String priceText) {
        this.priceText = priceText;
    }

    /**
     * deleted.
     *
     * @return the deleted
     */
    public Boolean getDeleted() {
        return deleted;
    }

    /**
     * deleted.
     *
     * @param deleted the deleted to set
     */
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    /**
     * delivery.
     *
     * @return the delivery
     */
    public String getDelivery() {
        return delivery;
    }

    /**
     * delivery.
     *
     * @param delivery the delivery to set
     */
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

}
