package com.qiho.center.api.enums;

import com.google.common.collect.Lists;
import org.apache.commons.codec.binary.StringUtils;

import java.util.List;

/**
 * Created by qianjue on 2017/11/1.
 * 全国一级行政区域枚举类
 */
public enum AreaEnum {

    北京市("110000","北京市","华北"),
	天津市("120000","天津市","华北"),
	河北省("130000","河北省","华北"),
	山西省("140000","山西省","华北"),
	内蒙古自治区("150000","内蒙古自治区","华北"),
	辽宁省("210000","辽宁省","东北"),
	吉林省("220000","吉林省","东北"),
	黑龙江省("230000","黑龙江省","东北"),
	上海市("310000","上海市","华东"),
	江苏省("320000","江苏省","华东"),
	浙江省("330000","浙江省","华东"),
	安徽省("340000","安徽省","华东"),
	福建省("350000","福建省","华东"),
	江西省("360000","江西省","华中"),
	山东省("370000","山东省","华东"),
	河南省("410000","河南省","华中"),
	湖北省("420000","湖北省","华中"),
	湖南省("430000","湖南省","华中"),
	广东省("440000","广东省","华南"),
	广西壮族自治区("450000","广西壮族自治区","华南"),
	海南省("460000","海南省","华南"),
	重庆市("500000","重庆市","西南"),
	四川省("510000","四川省","西南"),
	贵州省("520000","贵州省","西南"),
	云南省("530000","云南省","西南"),
	西藏自治区("540000","西藏自治区","西南"),
	陕西省("610000","陕西省","西北"),
	甘肃省("620000","甘肃省","西北"),
	青海省("630000","青海省","西北"),
	宁夏回族自治区("640000","宁夏回族自治区","西北"),
	新疆维吾尔自治区("650000","新疆维吾尔自治区","西北"),
	台湾省("710000","台湾省","港澳台"),
	香港特别行政区("810000","香港特别行政区","港澳台"),
	澳门特别行政区("820000","澳门特别行政区","港澳台"),
	;

	public static AreaEnum getAreaEnumByCode(String code){
		for(AreaEnum area : AreaEnum.values()){
			if(StringUtils.equals(code,area.getCode())){
				return area;
			}
		}
		return null;
	}

	public static List<AreaEnum> getAreaEnumByType(String type){
		List<AreaEnum> list = Lists.newArrayList();
		for(AreaEnum area : AreaEnum.values()){
			if(StringUtils.equals(type,area.getType())){
				list.add(area);
			}
		}
		return list;
	}

	AreaEnum(String code,String name,String type){
		this.code = code;
		this.name = name;
		this.type = type;
	}

	/**
	 * 归属区域:
	 */
	private  String  type;

	private  String  code;

	private  String  name;

	public String getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public String getType() {
		return type;
	}
}
