package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 查询获得的code 请参考
 * LogisticsOrderStatusEnum
 * Created by weny.cai on 2017/10/27.
 */
public enum JDLogisticsOrderStatusEnum {

    /** 妥投 */
    JD_SUCCESS("SUCCESS","妥投"),

    /** 快递签收 */
    JD_ACCEPT("ACCEPT","快递签收"),

    /** 接货中心接货 */
    JD_UNDER_WAY_GET("UNDER_WAY", "接货中心接货"),

    /** 分拣中心验货 */
    JD_UNDER_WAY_CENTER_CHECK("UNDER_WAY", "分拣中心验货"),

    /** 分拣中心发货 */
    JD_UNDER_WAY_CENTER_GET("UNDER_WAY", "分拣中心发货"),

    /** 站点收货 */
    JD_UNDER_SITE_ACCEPT("UNDER_WAY", "站点收货"),

    /** 站点验货 */
    JD_UNDER_SITE_CHECK("UNDER_WAY", "站点验货"),

    /** 配送员收货 */
    JD_SENT_SCAN("SENT_SCAN", "配送员收货"),

    /** 拒收 */
    JD_REJECTED("REJECTED", "拒收"),

    /** 再投 */
    JD_FAILED("FAILED","再投");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    JDLogisticsOrderStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return DatabaseSchema
     */
    public static JDLogisticsOrderStatusEnum getByCode(String code) {
        for (JDLogisticsOrderStatusEnum enumVal : JDLogisticsOrderStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }


    /**
     * getByDesc:
     * 根据京东物流状态获取
     * 奇货系统订单状态
     * @param desc
     * @return DatabaseSchema
     */
    public static JDLogisticsOrderStatusEnum getByDesc(String desc) {
        for (JDLogisticsOrderStatusEnum enumVal : JDLogisticsOrderStatusEnum.values()) {
            if (StringUtils.equals(desc, enumVal.getDesc())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }

}
