package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 快递100快递单当前签收状态
 * Author: zhanghuifeng
 * Date:   14:53 2017/11/23
 */
public enum KuaiDi100LogisticsOrderStatusEnum {


	/** 接单*/
	ACCEPT("1","已揽收"),

	/** 在途 */
	UNDER_WAY("0", "在途中"),

	/** 派件 */
	SENT_SCAN("5", "同城派送中"),

	/** 签收成功 */
	SUCCESS("3", "已签收"),

	/** 退件成功 */
	RETURN("4", "退签"),

	PUZZLE("2", "疑难"),

	SEND_BACK("6", "退回"),

    TRANSIT("7", "转投"),

	/** 拒签 */
	REJECTED("14", "拒签"),

	/** 监控终止 */
	ABORT("50", "中止");

	private String state;

	private String desc;

	KuaiDi100LogisticsOrderStatusEnum(String state, String desc){
		this.state = state;
		this.desc = desc;
	}

	/**
	 * getByCode
	 *
	 * @param state
	 * @return DatabaseSchema
	 */
	public static KuaiDi100LogisticsOrderStatusEnum getByState(String state) {
		for (KuaiDi100LogisticsOrderStatusEnum enumVal : KuaiDi100LogisticsOrderStatusEnum.values()) {
			if (StringUtils.equals(state, enumVal.getState())) {
				return enumVal;
			}
		}
		return null;
	}

	public String getState() {
		return state;
	}

	public String getDesc() {
		return desc;
	}
}
