/**
 * Project Name:qiho-center-api File Name:LogisticsNameEnum.java Package Name:com.qiho.center.api.enums
 * Date:2017年8月10日下午2:49:35 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:LogisticsNameEnum <br/>
 * 物流公司枚举. <br/>
 * Date: 2017年8月10日 下午2:49:35 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum LogisticsNameEnum {

    /** 圆通速递 */
    YTO("YTO", "圆通速递"),

    /** 汇通快运 */
    BEST_EX("BEST_EX", "汇通快运"),

    /** 京邦达*/
    JD("JD", "京邦达"),
    EMS_YOUBAO("EMS", "E邮宝"),
    STO("STO", "申通"),
    EMS("EMS", "EMS"),
    YTO2("YTO", "圆通"),
    HHTT("HHTT", "天天快递"),
    SF("SF", "顺丰快递"),
    SF_GJ("SF", "顺丰国际"),
    YD("YD", "韵达"),
    ZTO("ZTO", "中通"),
    HTKY("BEST_EX", "汇通"),
    STO2("STO", "申通快运"),
    UAPEX("UAPEX", "全一"),
    FEDEX("FEDEX", "联邦快递"),
    JD2("JD", "京东快递");

    /** 代码 */
    private String code;

    /** 物流公司名称 */
    private String name;

    LogisticsNameEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * 根据物流公司代码获取枚举
     * 
     * @param code
     * @return LogisticsNameEnum
     */
    public static LogisticsNameEnum getByCode(String code) {
        for (LogisticsNameEnum enumVal : LogisticsNameEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 根据物流公司名称获取枚举
     *
     * @param name
     * @return LogisticsNameEnum
     */
    public static LogisticsNameEnum getByName(String name) {
        for (LogisticsNameEnum enumVal : LogisticsNameEnum.values()) {
            if (StringUtils.equals(name, enumVal.getName())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return name
     */
    public String getName() {
        return name;
    }
}
