package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 导入导出物流公司
 * 对应枚举
 * Created by weny.cai on 2017/11/24.
 */
public enum WdtImportLogisticsNameEnum {

    YTO("YTO", "奇货COD圆通"),
    YTO2("YTO", "奇货圆通热敏"),
    ZTO("ZTO", "中通"),
    BEST_EX("BEST_EX", "汇通"),
    STO("STO", "申通"),
    YD("YD", "韵达"),
    YTO3("YTO", "圆通"),
    SF("SF", "顺丰"),
    ZTO2("ZTO", "中通快递"),
    BEST_EX1("BEST_EX", "百世汇通"),
    STO2("STO", "申通快递"),
    YD2("YD", "韵达快递"),
    YTO4("YTO", "圆通速递"),
    SF1("SF", "顺丰快递"),
    JD("JD", "京东快递"),
    EMS("EMS","EMS"),
    YZPY("YZPY","邮政快递"),
    DBL("DBL","德邦");

    /** 代码 */
    private String code;

    /** 物流公司名称 */
    private String name;

    WdtImportLogisticsNameEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * 根据物流公司代码获取枚举
     *
     * @param code
     * @return LogisticsNameEnum
     */
    public static WdtImportLogisticsNameEnum getByCode(String code) {
        for (WdtImportLogisticsNameEnum enumVal : WdtImportLogisticsNameEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 根据物流公司名称获取枚举
     *
     * @param name
     * @return LogisticsNameEnum
     */
    public static WdtImportLogisticsNameEnum getByName(String name) {
        for (WdtImportLogisticsNameEnum enumVal : WdtImportLogisticsNameEnum.values()) {
            if (StringUtils.equals(name, enumVal.getName())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return name
     */
    public String getName() {
        return name;
    }


}
