package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHNEnum implements AreaCodeEnumerable {
    CODE_410000("410000", "河南省"),
    CODE_410100("410100", "河南省郑州市"),
    CODE_410101("410101", "河南省郑州市市辖区"),
    CODE_410102("410102", "河南省郑州市中原区"),
    CODE_410103("410103", "河南省郑州市二七区"),
    CODE_410104("410104", "河南省郑州市管城回族区"),
    CODE_410105("410105", "河南省郑州市金水区"),
    CODE_410106("410106", "河南省郑州市上街区"),
    CODE_410108("410108", "河南省郑州市邙山区"),
    CODE_410122("410122", "河南省郑州市中牟县"),
    CODE_410181("410181", "河南省郑州市巩义市"),
    CODE_410182("410182", "河南省郑州市荥阳市"),
    CODE_410183("410183", "河南省郑州市新密市"),
    CODE_410184("410184", "河南省郑州市新郑市"),
    CODE_410185("410185", "河南省郑州市登封市"),
    CODE_410200("410200", "河南省开封市"),
    CODE_410201("410201", "河南省开封市市辖区"),
    CODE_410202("410202", "河南省开封市龙亭区"),
    CODE_410203("410203", "河南省开封市顺河回族区"),
    CODE_410204("410204", "河南省开封市鼓楼区"),
    CODE_410205("410205", "河南省开封市南关区"),
    CODE_410211("410211", "河南省开封市郊区"),
    CODE_410221("410221", "河南省开封市杞县"),
    CODE_410222("410222", "河南省开封市通许县"),
    CODE_410223("410223", "河南省开封市尉氏县"),
    CODE_410224("410224", "河南省开封市开封县"),
    CODE_410225("410225", "河南省开封市兰考县"),
    CODE_410300("410300", "河南省洛阳市"),
    CODE_410301("410301", "河南省洛阳市市辖区"),
    CODE_410302("410302", "河南省洛阳市老城区"),
    CODE_410303("410303", "河南省洛阳市西工区"),
    CODE_410304("410304", "河南省洛阳市廛河回族区"),
    CODE_410305("410305", "河南省洛阳市涧西区"),
    CODE_410306("410306", "河南省洛阳市吉利区"),
    CODE_410311("410311", "河南省洛阳市郊区"),
    CODE_410322("410322", "河南省洛阳市孟津县"),
    CODE_410323("410323", "河南省洛阳市新安县"),
    CODE_410324("410324", "河南省洛阳市栾川县"),
    CODE_410325("410325", "河南省洛阳市嵩县"),
    CODE_410326("410326", "河南省洛阳市汝阳县"),
    CODE_410327("410327", "河南省洛阳市宜阳县"),
    CODE_410328("410328", "河南省洛阳市洛宁县"),
    CODE_410329("410329", "河南省洛阳市伊川县"),
    CODE_410381("410381", "河南省洛阳市偃师市"),
    CODE_410400("410400", "河南省平顶山市"),
    CODE_410401("410401", "河南省平顶山市市辖区"),
    CODE_410402("410402", "河南省平顶山市新华区"),
    CODE_410403("410403", "河南省平顶山市卫东区"),
    CODE_410404("410404", "河南省平顶山市石龙区"),
    CODE_410411("410411", "河南省平顶山市湛河区"),
    CODE_410421("410421", "河南省平顶山市宝丰县"),
    CODE_410422("410422", "河南省平顶山市叶县"),
    CODE_410423("410423", "河南省平顶山市鲁山县"),
    CODE_410425("410425", "河南省平顶山市郏县"),
    CODE_410481("410481", "河南省平顶山市舞钢市"),
    CODE_410482("410482", "河南省平顶山市汝州市"),
    CODE_410500("410500", "河南省安阳市"),
    CODE_410501("410501", "河南省安阳市市辖区"),
    CODE_410502("410502", "河南省安阳市文峰区"),
    CODE_410503("410503", "河南省安阳市北关区"),
    CODE_410504("410504", "河南省安阳市铁西区"),
    CODE_410511("410511", "河南省安阳市郊区"),
    CODE_410522("410522", "河南省安阳市安阳县"),
    CODE_410523("410523", "河南省安阳市汤阴县"),
    CODE_410526("410526", "河南省安阳市滑县"),
    CODE_410527("410527", "河南省安阳市内黄县"),
    CODE_410581("410581", "河南省安阳市林州市"),
    CODE_410600("410600", "河南省鹤壁市"),
    CODE_410601("410601", "河南省鹤壁市市辖区"),
    CODE_410602("410602", "河南省鹤壁市鹤山区"),
    CODE_410603("410603", "河南省鹤壁市山城区"),
    CODE_410611("410611", "河南省鹤壁市郊区"),
    CODE_410621("410621", "河南省鹤壁市浚县"),
    CODE_410622("410622", "河南省鹤壁市淇县"),
    CODE_410700("410700", "河南省新乡市"),
    CODE_410701("410701", "河南省新乡市市辖区"),
    CODE_410702("410702", "河南省新乡市红旗区"),
    CODE_410703("410703", "河南省新乡市新华区"),
    CODE_410704("410704", "河南省新乡市北站区"),
    CODE_410711("410711", "河南省新乡市郊区"),
    CODE_410721("410721", "河南省新乡市新乡县"),
    CODE_410724("410724", "河南省新乡市获嘉县"),
    CODE_410725("410725", "河南省新乡市原阳县"),
    CODE_410726("410726", "河南省新乡市延津县"),
    CODE_410727("410727", "河南省新乡市封丘县"),
    CODE_410728("410728", "河南省新乡市长垣县"),
    CODE_410781("410781", "河南省新乡市卫辉市"),
    CODE_410782("410782", "河南省新乡市辉县市"),
    CODE_410800("410800", "河南省焦作市"),
    CODE_410801("410801", "河南省焦作市市辖区"),
    CODE_410802("410802", "河南省焦作市解放区"),
    CODE_410803("410803", "河南省焦作市中站区"),
    CODE_410804("410804", "河南省焦作市马村区"),
    CODE_410811("410811", "河南省焦作市山阳区"),
    CODE_410821("410821", "河南省焦作市修武县"),
    CODE_410822("410822", "河南省焦作市博爱县"),
    CODE_410823("410823", "河南省焦作市武陟县"),
    CODE_410825("410825", "河南省焦作市温县"),
    CODE_410881("410881", "河南省焦作市济源市"),
    CODE_410882("410882", "河南省焦作市沁阳市"),
    CODE_410883("410883", "河南省焦作市孟州市"),
    CODE_410900("410900", "河南省濮阳市"),
    CODE_410901("410901", "河南省濮阳市市辖区"),
    CODE_410902("410902", "河南省濮阳市市区"),
    CODE_410922("410922", "河南省濮阳市清丰县"),
    CODE_410923("410923", "河南省濮阳市南乐县"),
    CODE_410926("410926", "河南省濮阳市范县"),
    CODE_410927("410927", "河南省濮阳市台前县"),
    CODE_410928("410928", "河南省濮阳市濮阳县"),
    CODE_411000("411000", "河南省许昌市"),
    CODE_411001("411001", "河南省许昌市市辖区"),
    CODE_411002("411002", "河南省许昌市魏都区"),
    CODE_411023("411023", "河南省许昌市许昌县"),
    CODE_411024("411024", "河南省许昌市鄢陵县"),
    CODE_411025("411025", "河南省许昌市襄城县"),
    CODE_411081("411081", "河南省许昌市禹州市"),
    CODE_411082("411082", "河南省许昌市长葛市"),
    CODE_411100("411100", "河南省漯河市"),
    CODE_411101("411101", "河南省漯河市市辖区"),
    CODE_411102("411102", "河南省漯河市源汇区"),
    CODE_411121("411121", "河南省漯河市舞阳县"),
    CODE_411122("411122", "河南省漯河市临颍县"),
    CODE_411123("411123", "河南省漯河市郾城县"),
    CODE_411200("411200", "河南省三门峡市"),
    CODE_411201("411201", "河南省三门峡市市辖区"),
    CODE_411202("411202", "河南省三门峡市湖滨区"),
    CODE_411221("411221", "河南省三门峡市渑池县"),
    CODE_411222("411222", "河南省三门峡市陕县"),
    CODE_411224("411224", "河南省三门峡市卢氏县"),
    CODE_411281("411281", "河南省三门峡市义马市"),
    CODE_411282("411282", "河南省三门峡市灵宝市"),
    CODE_411300("411300", "河南省南阳市"),
    CODE_411301("411301", "河南省南阳市市辖区"),
    CODE_411302("411302", "河南省南阳市宛城区"),
    CODE_411303("411303", "河南省南阳市卧龙区"),
    CODE_411321("411321", "河南省南阳市南召县"),
    CODE_411322("411322", "河南省南阳市方城县"),
    CODE_411323("411323", "河南省南阳市西峡县"),
    CODE_411324("411324", "河南省南阳市镇平县"),
    CODE_411325("411325", "河南省南阳市内乡县"),
    CODE_411326("411326", "河南省南阳市淅川县"),
    CODE_411327("411327", "河南省南阳市社旗县"),
    CODE_411328("411328", "河南省南阳市唐河县"),
    CODE_411329("411329", "河南省南阳市新野县"),
    CODE_411330("411330", "河南省南阳市桐柏县"),
    CODE_411381("411381", "河南省南阳市邓州市"),
    CODE_411400("411400", "河南省商丘市"),
    CODE_411401("411401", "河南省商丘市市辖区"),
    CODE_411402("411402", "河南省商丘市梁园区"),
    CODE_411403("411403", "河南省商丘市睢阳区"),
    CODE_411421("411421", "河南省商丘市民权县"),
    CODE_411422("411422", "河南省商丘市睢县"),
    CODE_411423("411423", "河南省商丘市宁陵县"),
    CODE_411424("411424", "河南省商丘市柘城县"),
    CODE_411425("411425", "河南省商丘市虞城县"),
    CODE_411426("411426", "河南省商丘市夏邑县"),
    CODE_411481("411481", "河南省商丘市永城市"),
    CODE_411500("411500", "河南省信阳市"),
    CODE_411501("411501", "河南省信阳市市辖区"),
    CODE_411502("411502", "河南省信阳市师河区"),
    CODE_411503("411503", "河南省信阳市平桥区"),
    CODE_411521("411521", "河南省信阳市罗山县"),
    CODE_411522("411522", "河南省信阳市光山县"),
    CODE_411523("411523", "河南省信阳市新县"),
    CODE_411524("411524", "河南省信阳市商城县"),
    CODE_411525("411525", "河南省信阳市固始县"),
    CODE_411526("411526", "河南省信阳市潢川县"),
    CODE_411527("411527", "河南省信阳市淮滨县"),
    CODE_411528("411528", "河南省信阳市息县"),
    CODE_412700("412700", "河南省周口地区"),
    CODE_412701("412701", "河南省周口地区周口市"),
    CODE_412702("412702", "河南省周口地区项城市"),
    CODE_412721("412721", "河南省周口地区扶沟县"),
    CODE_412722("412722", "河南省周口地区西华县"),
    CODE_412723("412723", "河南省周口地区商水县"),
    CODE_412724("412724", "河南省周口地区太康县"),
    CODE_412725("412725", "河南省周口地区鹿邑县"),
    CODE_412726("412726", "河南省周口地区郸城县"),
    CODE_412727("412727", "河南省周口地区淮阳县"),
    CODE_412728("412728", "河南省周口地区沈丘县"),
    CODE_412800("412800", "河南省驻马店地区"),
    CODE_412801("412801", "河南省驻马店地区驻马店市"),
    CODE_412821("412821", "河南省驻马店地区确山县"),
    CODE_412822("412822", "河南省驻马店地区泌阳县"),
    CODE_412823("412823", "河南省驻马店地区遂平县"),
    CODE_412824("412824", "河南省驻马店地区西平县"),
    CODE_412825("412825", "河南省驻马店地区上蔡县"),
    CODE_412826("412826", "河南省驻马店地区汝南县"),
    CODE_412827("412827", "河南省驻马店地区平舆县"),
    CODE_412828("412828", "河南省驻马店地区新蔡县"),
    CODE_412829("412829", "河南省驻马店地区正阳县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHNEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
