package com.qiho.center.api.enums.ordersms;

import com.qiho.center.api.constant.OrderStrategyConstant;
import org.apache.commons.lang.StringUtils;

/** 下单手机号状态枚举
 * @author chensong
 * @create 2018-05-18 17:30
 **/
public enum SmsMobileStatusEnum {

    DEFAULT(0,"","默认"),

    SUCCESS(1, "bq888", "成功"),

    CLOSE_DOWN(2, "bq001", "关机或停机"),

    EMPTY_NUM(3, "bq003", "空号"),

    BLACKLIST(4, "bq002", "黑名单"),

    UNKNOWN(5, "bq000", "未知"),

    TIME_OUT(6, "bq999" ,"超时"),


    ;


    private int num;

    /** 百奇内部的返回码 */
    private String code;

    private String desc;

    private SmsMobileStatusEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static  SmsMobileStatusEnum getByNum(int num){
        for (SmsMobileStatusEnum value : SmsMobileStatusEnum.values()) {
            if (value.getNum() == num) {
                return value;
            }
        }
        return null;
    }

    /**
     * 根据百奇返回码 bq888这类的 来获取更新防作弊信息的文案
     * @param code
     * @return
     */
    public static String getUpdateTextByCode(String code){
        String anticheatInfo =  StringUtils.EMPTY;
        if (StringUtils.isBlank(code)) {
            return anticheatInfo;
        }

        switch (code) {
            case "bq888":
                anticheatInfo = OrderStrategyConstant.SHOTORDER_TIMEOUT_RECEIVED_SUCCESS;
                break;
            case "bq001":
                anticheatInfo = OrderStrategyConstant.SHOTORDER_TIMEOUT_RECEIVED_CLOSE;
                break;
            case "bq003":
                anticheatInfo = OrderStrategyConstant.SHOTORDER_TIMEOUT_RECEIVED_EMPTY;
                break;
            case "bq002":
                anticheatInfo = OrderStrategyConstant.SHOTORDER_TIMEOUT_RECEIVED_BLACKLIST;
                break;
            case "bq000":
            case "bq999":
                anticheatInfo = OrderStrategyConstant.SHOTORDER_TIMEOUT_RECEIVED_ERROR;
                break;
            default:
                break;
        }

        return anticheatInfo;
    }







}
