package com.qiho.center.api.enums.ordertmp;

import org.apache.commons.lang3.StringUtils;

/**
 * 临时订单状态枚举
 * @author chensong
 * @create 2018-05-14 11:59
 **/
public enum OrderTmpStatusEnum {

    /**
     *
     */
    TO_FILTER(1, "TO_FILTER", "待过滤"),

    INVALID(2, "INVALID", "无效");

    private int num;

    private String code;

    private String desc;

    OrderTmpStatusEnum(int num, String code, String desc){
        this.num = num;
        this.code = code;
        this.desc = desc;
    }

    public int getNum() {
        return num;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static OrderTmpStatusEnum getByCode(String code){
        if (StringUtils.isBlank(code)) {
            return null;
        }
        for (OrderTmpStatusEnum value : OrderTmpStatusEnum.values()) {
            if (StringUtils.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    public static OrderTmpStatusEnum getByNum(int num){
        for (OrderTmpStatusEnum value : OrderTmpStatusEnum.values()) {
            if (num == value.getNum()) {
                return value;
            }
        }
        return null;
    }



}
