package com.qiho.center.api.enums.purchase;

import org.apache.commons.lang3.StringUtils;

import java.util.stream.Stream;

/**
 * 加购类型
 *
 * @author peanut.huang
 * @date 2020/7/10
 * @since JDK 1.8
 */
public enum PurchaseTypeEnum {

    BIG, JF, CB;

    /**
     * 根据类型查询
     *
     * @param type
     * @return
     */
    public static PurchaseTypeEnum findByType(String type){
        if(StringUtils.isBlank(type)){
            return null;
        }

       return Stream.of(PurchaseTypeEnum.values())
                    .filter(e -> e.toString().equals(type))
                    .findFirst()
                    .orElse(null);
    }
}
