package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.BandDto;
import com.qiho.center.api.params.BandParams;

import java.util.List;

/**
 * Created by liuyao on 2017/5/24.
 */
@AdvancedFeignClient
public interface RemoteBandService {
    /**
     * 获取所有的Band
     * @return
     */
    public DubboResult<List<BandDto>> findAllBand();

    /**
     * 保存Band
     * @param params
     * @return
     */
    public DubboResult<Integer> saveBand(BandParams params);

    /**
     * 改变band的启用状态
     * @param id
     * @return
     */
    public DubboResult<Boolean> changeBandShowEnable(Long id);

    /**
     * 排序Band
     * @param bandIds
     * @return
     */
    public DubboResult<Integer> sortBand(List<Long> bandIds);

    /**
     * 删除Band
     * @param id
     * @return
     */
    public DubboResult<Integer> deleteBand(Long id);


}
