package com.qiho.center.api.remoteservice.monitor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.monitor.LogisticsMonitorPlanDto;
import com.qiho.center.api.params.MonitorPlanQueryParam;

/**
 * Created by qianjue on 2017/11/1.
 */
@AdvancedFeignClient
public interface RemoteLogisticsMonitorPlanService {

	/**
	 * 新增修改
	 * @param dto
	 * @return
	 * @throws BizException
	 */
	int  createMonitorPlan(LogisticsMonitorPlanDto dto) throws BizException;

	/**
	 * 分页查询
	 * @param queryParam
	 * @return
	 */
	PagenationDto<LogisticsMonitorPlanDto> queryPageList(MonitorPlanQueryParam queryParam);

	/**
	 * 查询
	 * @param id
	 * @return
	 */
	LogisticsMonitorPlanDto  selectDetailById(Long id);

	/**
	 * 删除
	 * @param id
	 * @return
	 */
	int  deleteMonitorPlan(Long  id);
}
