package com.qiho.center.api.remoteservice.order;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.DeliveryRecordDto;
import com.qiho.center.api.params.DeliveryRecordQueryParams;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 订单批量操作记录远程接口
 *
 * @author jiafeng.geng
 * @create 2018-03-08 16:03:57
 **/
@AdvancedFeignClient
public interface RemoteDeliveryRecordService {

    /**
     * 保存订单批量操作记录
     *
     * @param dto
     *
     * @return
     */
    Boolean insertDeliveryRecord(DeliveryRecordDto dto) throws BizException;

    /**
     * 分页查询订单批量操作记录信息
     *
     * @param params
     *
     * @return
     */
    PagenationDto<DeliveryRecordDto> deliveryRecordPageQuery(DeliveryRecordQueryParams params);

    /**
     * 查询当日订单批量操作记录信息上传次数
     *
     * @param merchantId
     *
     * @return
     */
    int findTodayCount(Long merchantId);

    /**
     * 执行任务
     *
     * @param
     *
     * @return
     */
    void doOrderFileDeliveryJob();
}
