package com.qiho.center.api.remoteservice.trading.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.trading.statistics.ShopTradingStatisticsDto;
import com.qiho.center.api.dto.trading.statistics.ShopTradingStatisticsTotalDto;
import com.qiho.center.api.params.trading.statistics.ShopTradingStatisticsPageParam;

/**
 * @author Wangpf
 * @description  商家交易统计远程服务
 * @date 2020/9/1 5:39 下午
 */
@AdvancedFeignClient
public interface RemoteShopTradingStatisticsService {

    /**
     * 分页查询商家交易记录
     *
     * @param shopTradingStatisticsPageParam
     * @return
     */
    PagenationDto<ShopTradingStatisticsDto> pageQuery(ShopTradingStatisticsPageParam shopTradingStatisticsPageParam);

    /**
     * 计算总金额
     *
     * @return
     */
    ShopTradingStatisticsTotalDto totalQuery(ShopTradingStatisticsPageParam shopTradingStatisticsPageParam);

    /**
     * 根据店铺Id进行查询
     *
     * @param shopId
     * @return
     */
    ShopTradingStatisticsDto getTradingStatisticsByShopId(Long shopId);
}
