package com.qiho.center.api.remoteservice.user;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.user.BaiqiUserBlacklistDTO;
import com.qiho.center.api.enums.user.UserBlacklistEnum;

/**
 * 用户黑名单服务
 *
 * @author peanut.huang
 * @date 2020/6/22
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteUserBlacklistService {

    /**
     * 添加用户黑名单
     *
     * @param userBlacklistDTO
     * @return id
     */
    Long insert(BaiqiUserBlacklistDTO userBlacklistDTO);

    /**
     * 设备号是否在指定类型的黑名单内
     *
     * @param deviceId      设备号
     * @param blackType     黑名单类型 {@link UserBlacklistEnum#getType()}
     * @return
     * @throws BizException 设备号或者黑名单类型错误时抛出异常
     */
    boolean deviceIdInBlacklist(String deviceId, Integer blackType) throws BizException;

    /**
     * 订单号是否在指定类型的黑名单内：
     *
     * a、订单号查询到具体的设备号
     * b、再查询设备号是否在黑名单中 {@method deviceIdInBlacklist}
     *
     * @param orderId       订单号
     * @param blackType     黑名单类型 {@link UserBlacklistEnum#getType()}
     * @return
     * @throws BizException 订单号或者黑名单类型错误时抛出异常
     */
    boolean orderIdInBlacklist(String orderId, Integer blackType) throws BizException;

}
