package com.qiho.center.api.remoteservice.user;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.user.UserEvaluateDto;
import com.qiho.center.api.dto.user.WechatUserDto;
import com.qiho.center.api.params.user.UserEvaluatePagingParams;

/**
 * 用户评价
 * @author: wangjin
 * @create 2018-05-23 14:04
 */
@AdvancedFeignClient
public interface RemoteUserEvaluateService {

    /**
     * 保存用户评价
     * @param record
     * @return
     */
    int insertUserEvaluate(UserEvaluateDto record);

    /**
     * 查询用户评价数量
     * @param orderId
     * @return
     */
    int selectUserEvaluateCount(String orderId);

    /**
     * 查询用户最近的一条评价信息
     * @param orderId
     * @return
     */
    UserEvaluateDto selectLatestUserEvaluate(String orderId);

    /**
     * 分页查询用户评价
     *
     * @param pagingParams  分页查询参数
     * @return
     */
    PagenationDto<UserEvaluateDto> findPaing(UserEvaluatePagingParams pagingParams);

    /**
     * 根据查询参数查询列表
     *
     * @param pagingParams  分页查询参数
     * @return
     */
    List<UserEvaluateDto> findEvaluateList(UserEvaluatePagingParams pagingParams);
}
