/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.ShotOrder;

import com.qiho.center.api.dto.resultbase.ResultBase;
import com.qiho.center.api.enums.ShotOrder.ShotOrderValute;
import com.qiho.center.api.enums.area.AreaCodeEnum;
import com.qiho.center.api.enums.bean.LocationCheckBean;
import com.qiho.center.api.util.AddressUtil;
import com.qiho.center.api.util.IdCardUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum ShotOrderRuleEnum implements ShotOrderValute
{
    LESS_THAN(0, "\u5c0f\u4e8e", "lesser"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) > Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    LESS_EQUALS(1, "\u5c0f\u4e8e\u7b49\u4e8e", "lesserEquals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) >= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    GREATER_EQUALS(2, "\u5927\u4e8e\u7b49\u4e8e", "greaterEquals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) <= Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    GREATER_THAN(3, "\u5927\u4e8e", "greater"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            Boolean result = Integer.valueOf(threshold) < Integer.valueOf(String.valueOf(hopeVal));
            return ResultBase.rightReturn(result);
        }
    }
    ,
    EQUALS_THAN(4, "\u7b49\u4e8e", "equals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            return ResultBase.rightReturn(threshold.equals(String.valueOf(hopeVal)));
        }
    }
    ,
    CONTAINS_THAN(5, "\u5305\u542b", "contains"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount > 0L);
        }
    }
    ,
    EMPTY_THAN(6, "\u4e3a\u7a7a", "hollow"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.TRUE : StringUtils.isBlank((String)String.valueOf(hopeVal)));
        }
    }
    ,
    NOT_EQUALS_THAN(6, "\u4e0d\u7b49\u4e8e", "notequals"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            ResultBase<Boolean> resultBase = ShotOrderValute.baseParamsCheck(threshold, hopeVal);
            if (!resultBase.hasSuccessValue()) {
                return resultBase;
            }
            return ResultBase.rightReturn(!threshold.equals(String.valueOf(hopeVal)));
        }
    }
    ,
    NOT_EMPTY_THAN(7, "\u4e0d\u4e3a\u7a7a", "nothollow"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(hopeVal == null ? Boolean.FALSE : StringUtils.isNotBlank((String)String.valueOf(hopeVal)));
        }
    }
    ,
    CONTAINS_COMMA(8, "\u5305\u542b\u9017\u53f7", "containsComma"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = new String[]{",", "\uff0c"};
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount > 0L);
        }
    }
    ,
    NOT_CONTAINS_THAN(9, "\u4e0d\u5305\u542b", "notcontains"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (null == threshold || null == hopeVal) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            String hopeValStr = String.valueOf(hopeVal);
            String[] thresholdStr = threshold.split(",");
            Long filterCount = Arrays.stream(thresholdStr).filter(e -> StringUtils.contains((String)hopeValStr, (String)e)).count();
            return ResultBase.rightReturn(filterCount.intValue() == 0);
        }
    }
    ,
    UN_KNOWS(10, "\u672a\u77e5", "unknowns"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"bq000", (String)hopeValStr));
        }
    }
    ,
    EMPTY_NUM(11, "\u7a7a\u53f7", "emptyNum"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"bq003", (String)hopeValStr));
        }
    }
    ,
    TIME_OUT(12, "\u8d85\u65f6", "timeOut"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"bq999", (String)hopeValStr));
        }
    }
    ,
    CLOSE_DOWN(13, "\u5173\u673a\u6216\u505c\u673a", "closeDown"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"bq001", (String)hopeValStr));
        }
    }
    ,
    BLACKLIST(14, "\u9ed1\u540d\u5355", "blacklist"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(StringUtils.equals((String)"bq002", (String)hopeValStr));
        }
    }
    ,
    ALL_DIFFER(15, "\u5b8c\u5168\u4e0d\u540c\uff08\u7701\uff09", "ALL_DIFFER"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            LocationCheckBean bean = (LocationCheckBean)hopeVal;
            if (!(bean.getProvince().equals(bean.getIpProvince()) || bean.getProvince().equals(bean.getMobileProvince()) || bean.getIpProvince().equals(bean.getMobileProvince()))) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            return ResultBase.rightReturn(Boolean.FALSE);
        }
    }
    ,
    MOBILE_ADDRESS_DIFFER(16, "\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u548c\u6536\u8d27\u5730\u5740\u4e0d\u540c\uff08\u5230\u7701\uff09", "MOBILE_ADDRESS_DIFFER"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            LocationCheckBean bean = (LocationCheckBean)hopeVal;
            if (!bean.getProvince().equals(bean.getMobileProvince())) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            return ResultBase.rightReturn(Boolean.FALSE);
        }
    }
    ,
    MOBILE_ADDRESS_DIFFER_CITY(17, "\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u548c\u6536\u8d27\u5730\u5740\u4e0d\u540c\uff08\u5230\u7701\u5e02\uff09", "MOBILE_ADDRESS_DIFFER_CITY"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            LocationCheckBean bean = (LocationCheckBean)hopeVal;
            if (!bean.getCity().equals(bean.getMobileCity()) || !bean.getProvince().equals(bean.getMobileProvince())) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            return ResultBase.rightReturn(Boolean.FALSE);
        }
    }
    ,
    NOT_CONTAIN_CN(12, "\u4e0d\u5305\u542b\u4e2d\u6587", "notContainCN"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(this.notContainCN(hopeValStr));
        }

        private boolean notContainCN(String str) {
            String regex = "[\\u4e00-\\u9fa5]";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            return !m.find();
        }
    }
    ,
    ADDRESS_INVALID(13, "\u5730\u5740\u65e0\u6548", "addressInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(Integer.valueOf(String.valueOf(hopeVal)) <= 0);
        }
    }
    ,
    ADDRESS_OUT_OF_RANGE(14, "\u5305\u542b", "addressOutOfRange"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)threshold)) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            LocationCheckBean bean = (LocationCheckBean)hopeVal;
            String orderProvince = bean.getProvince();
            String orderCity = bean.getCity();
            if (StringUtils.isEmpty((String)orderProvince) || StringUtils.isEmpty((String)orderCity)) {
                return ResultBase.rightReturn(false);
            }
            HashMap provinceCityMap = new HashMap(16);
            for (String provinceCity : threshold.split(",")) {
                if (StringUtils.isEmpty((String)provinceCity)) continue;
                String[] provinceCityArray = provinceCity.split("-");
                String province = provinceCityArray[0];
                HashSet citys = provinceCityArray.length > 1 ? (Set)Optional.ofNullable(provinceCityArray[1]).map(temp -> Stream.of(temp.split("&")).collect(Collectors.toSet())).orElse(new HashSet()) : new HashSet();
                provinceCityMap.put(province, citys);
            }
            if (AddressUtil.isMunicipality(orderProvince) && provinceCityMap.containsKey(orderProvince)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            Set cityList = (Set)provinceCityMap.get(orderProvince);
            if (cityList == null || !cityList.contains(orderCity)) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            return ResultBase.rightReturn(Boolean.TRUE);
        }
    }
    ,
    ID_CARD_AGE_INVALID(18, "\u8eab\u4efd\u8bc1\u5e74\u9f84\u65e0\u6548", "idCardAgeInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (Objects.isNull(hopeVal)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            String idCard = String.valueOf(hopeVal);
            if (idCard.matches("^\\d{15}$")) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            if (!idCard.matches("^\\d{17}[0-9Xx]$")) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                Date birthDate = sdf.parse(idCard.substring(6, 14));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(1, -18);
                calendar.getTime();
                return ResultBase.rightReturn(birthDate.compareTo(calendar.getTime()) > 0);
            }
            catch (ParseException e1) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
        }
    }
    ,
    ID_CARD_FORMAT_INVALID(19, "\u8eab\u4efd\u8bc1\u683c\u5f0f\u65e0\u6548", "idCardFormatInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (Objects.isNull(hopeVal)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            String idCard = String.valueOf(hopeVal);
            if (idCard.matches("^\\d{17}[0-9Xx]$") && IdCardUtil.checkIdCardFormat(idCard)) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            return ResultBase.rightReturn(Boolean.TRUE);
        }
    }
    ,
    ID_CARD_AREA_INVALID(20, "\u8eab\u4efd\u8bc1\u533a\u53f7\u65e0\u6548", "idCardAreaInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (Objects.isNull(hopeVal)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            String idCard = String.valueOf(hopeVal);
            if (idCard.matches("^\\d{15}$")) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            if (!idCard.matches("^\\d{17}[0-9Xx]$")) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            AreaCodeEnum areaCodeEnum = AreaCodeEnum.getByCode(idCard.substring(0, 2));
            if (Objects.isNull((Object)areaCodeEnum)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            return ResultBase.rightReturn(!areaCodeEnum.getAreaCodeEnumerable().isExist(idCard.substring(0, 6)));
        }
    }
    ,
    ID_CARD_AGE_GREATER_THAN(21, "\u5927\u4e8e", "idCardAgeGreaterThan"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (Objects.isNull(hopeVal)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            String idCard = String.valueOf(hopeVal);
            if (idCard.matches("^\\d{15}$")) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            if (!idCard.matches("^\\d{17}[0-9Xx]$")) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                Date birthDate = sdf.parse(idCard.substring(6, 14));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(1, Integer.valueOf(threshold) * -1);
                calendar.getTime();
                return ResultBase.rightReturn(birthDate.compareTo(calendar.getTime()) < 0);
            }
            catch (ParseException e1) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
        }
    }
    ,
    ID_CARD_AGE_LESS_THAN(22, "\u5c0f\u4e8e", "idCardAgeLessThan"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            if (Objects.isNull(hopeVal)) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            String idCard = String.valueOf(hopeVal);
            if (idCard.matches("^\\d{15}$")) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
            if (!idCard.matches("^\\d{17}[0-9Xx]$")) {
                return ResultBase.rightReturn(Boolean.TRUE);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            try {
                Date birthDate = sdf.parse(idCard.substring(6, 14));
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                calendar.add(1, Integer.valueOf(threshold) * -1);
                calendar.getTime();
                return ResultBase.rightReturn(birthDate.compareTo(calendar.getTime()) > 0);
            }
            catch (ParseException e1) {
                return ResultBase.rightReturn(Boolean.FALSE);
            }
        }
    }
    ,
    NOT_ONLY_CN(23, "\u975e\u7eaf\u4e2d\u6587", "notOnlyCN"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            String hopeValStr = String.valueOf(hopeVal);
            return ResultBase.rightReturn(!this.isFullChinese(hopeValStr));
        }

        private boolean isFullChinese(String str) {
            String reg = "[\\u4e00-\\u9fa5]+";
            return str.matches(reg);
        }
    }
    ,
    ID_NAME_INVALID(24, "\u8eab\u4efd\u8bc1\u540d\u5b57\u4e0d\u5339\u914d", "idNameInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(true);
        }
    }
    ,
    MOBILE_QUALIFICATION_INVALID(25, "\u624b\u673a\u53f7\u65e0\u6548", "mobileQualificationInvalid"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(true);
        }
    }
    ,
    ZUOYEBANG_OVERSOLD(26, "\u8d85\u51fa\u4f5c\u4e1a\u5e2e\u5546\u54c1\u5e93\u5b58", "zuoyebangOversold"){

        @Override
        public ResultBase<Boolean> valuteOrderByQuery(String threshold, Object hopeVal) {
            return ResultBase.rightReturn(true);
        }
    };

    int code;
    String msg;
    String val;

    public static ShotOrderRuleEnum fromStatus(Integer code) {
        if (code == null) {
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (shotOrderRuleEnum.getCode() != code.intValue()) continue;
            return shotOrderRuleEnum;
        }
        return null;
    }

    public static ShotOrderRuleEnum fromVal(String val) {
        if (StringUtils.isBlank((String)val)) {
            return null;
        }
        for (ShotOrderRuleEnum shotOrderRuleEnum : ShotOrderRuleEnum.values()) {
            if (!shotOrderRuleEnum.getVal().equals(val)) continue;
            return shotOrderRuleEnum;
        }
        return null;
    }

    private ShotOrderRuleEnum(int code, String msg, String val) {
        this.code = code;
        this.msg = msg;
        this.val = val;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getVal() {
        return this.val;
    }
}

