package com.qiho.center.api.enums.merchant;

import java.util.stream.Stream;

/**
 * 百奇商家对外关联类型枚举
 *
 * @author peanut.huang
 * @date 2017/12/27.
 */
public enum BaiqiMerchantLinkTypeEnum {
    TUI_A(1, "推啊");

    /**
     * 类型值
     */
    private int type;

    /**
     * 描述
     */
    private String desc;


    BaiqiMerchantLinkTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据类型值查询
     *
     * @param type   类型值
     * @return         类型枚举
     */
    public static BaiqiMerchantLinkTypeEnum findByType(Integer type){
        if(type == null){
            return null;
        }

        return Stream.of(BaiqiMerchantLinkTypeEnum.values()).filter(e -> e.getType() == type).findFirst().orElse(null);
    }


    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
