package com.qiho.center.api.enums.trading.record;

import java.util.Objects;

/**
 * @author Wangpf
 * @description 订单未结算的原因 优先级 随着code 变大依次降低
 *
 *  UNLIQUIDATED_PERIOD > AFTER_SALE > MANUAL_TO_CONFIRM > NOT_FINAL_STATE > OTHER
 *
 * @date 2020/9/5 11:10 上午
 */
public enum NotCloseReasonEnum {

    UNLIQUIDATED_PERIOD(1, "未满结算周期"),

    AFTER_SALE(2, "售后中订单"),

    MANUAL_TO_CONFIRM(3, "人工确认订单"),

    NOT_FINAL_STATE(4, "非终态订单"),

    OTHER(5, "其他");


    private final int code;

    private final String desc;

    NotCloseReasonEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        for (NotCloseReasonEnum notCloseReasonEnum : NotCloseReasonEnum.values()) {
            if (null != code && code == notCloseReasonEnum.getCode()) {
                return notCloseReasonEnum.getDesc();
            }
        }

        return OTHER.getDesc();
    }

    public static Integer getCodeByDesc(String msg) {
        for (NotCloseReasonEnum notCloseReasonEnum : NotCloseReasonEnum.values()) {
            if (Objects.equals(msg, notCloseReasonEnum.getDesc())) {
                return notCloseReasonEnum.getCode();
            }
        }

        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
