/**
 * Project Name:qiho-center-api File Name:RemoteLogisticsOrderService.java Package
 * Name:com.qiho.center.api.remoteLogisticsOrderService Date:2017年6月3日 下午3:37:46 Copyright (c) 2017, duiba.com.cn All
 * Rights Reserved.
 */

package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.dto.logistics.LogisticsProcessDto;
import com.qiho.center.api.dto.logistics.QueryLogisticsOrderDto;
import com.qiho.center.api.enums.LogisticsNameEnum;

import java.util.List;

/**
 * ClassName: RemoteLogisticsOrderService <br/>
 * Function: 物流子订单管理dubbo服务. <br/>
 * date: 2017年6月3日 下午3:37:46 <br/>
 *
 * @author chencheng
 * @version
 */
@AdvancedFeignClient
public interface RemoteLogisticsOrderService {

    /**
     * 分页查询物流子订单
     *
     * @author chencheng
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return
     */
    DubboResult<PagenationDto<LogisticsOrderDto>> queryLogisticsOrderPage(QueryLogisticsOrderDto queryItem,
                                                                          Integer pageNum, Integer pageSize);

    /**
     * 更新订单状态
     *
     * @author chencheng
     * @param logisticsId
     * @param orderStatus
     * @return
     */
    DubboResult<Integer> updateBylogisticsId(String logisticsIds, String orderStatus);

    /**
     * 更新物流子订单物流状态
     *
     * @author chencheng
     * @param logisticsOrderDto
     * @return
     */
    DubboResult<Integer> updateLogisticsOrderStatus(LogisticsOrderDto logisticsOrderDto);

    /**
     * 根据订单ID查询物流信息
     *
     * @author zhanglihui
     * @param orderId
     * @return List<LogisticsOrderDto>
     */
    DubboResult<List<LogisticsOrderDto>> findByOrderId(String orderId);

    /**
     * 查询圆通快递运单走件流程</br>
     * 使用通用物流查询接口{@link RemoteLogisticsOrderService#queryWaybillTrace(String, String)}
     * @author zhanglihui
     * @param postId
     * @return List<LogisticsOrderDto>
     * @deprecated
     */
    @Deprecated
    DubboResult<List<LogisticsProcessDto>> queryYTOLogisticsProcessByPostId(String postId);

    /**
     * 根据物流公司和快递单号查询物流走件信息
     *
     * @author zhanglihui
     * @param logisticsCode 物流公司代码{@link LogisticsNameEnum}
     * @param postId 快递单号
     * @return 走件信息，返回结果按照时间倒序排序
     */
    DubboResult<List<LogisticsProcessDto>> queryWaybillTrace(String logisticsCode, String postId);

    /**
     * 批量签收物流订单
     * 
     * @param progressKey 审核进度查询Key,用于向缓存中写进度,调用batchAuditOrderInit获取
     * @param paramList
     * @return 提交的审核条数
     */
    DubboResult<Integer> batchSignOrder(String progressKey, List<LogisticsOrderDto> paramList);

    /**
     * 手动触发查询ERP系统物流发货信息查询
     * 
     * @return 是否执行
     */
    DubboResult<Boolean> manualErpLogisticsSyncQueryJob();

    /**
     * 通过查询走件信息同步物流状态
     *
     * @author zhanglihui
     * @param logisticsOrderStatus
     * @return DubboResult
     */
    DubboResult<Void> syncLogisticsStatus(String logisticsOrderStatus);


    int  queryDistributeOverTimeNum();


    List<LogisticsOrderDto> queryDistributeOverTimePage( Integer pageNum, Integer pageSize);
    /**
     * 修改物流订单备注
     */
    Boolean updateLogisticsOrderRemark(LogisticsOrderDto param);

    /**
     * 查询客服跟单物流订单
     */
    PagenationDto<LogisticsOrderDto> queryServiceLogisticsOrder(QueryLogisticsOrderDto queryItem, Integer pageNum, Integer pageSize);

    /**
     * 触发京东物流同步接口
     * 方便测试
     */
    void syncLogisticsOrderStatus();

    /**
     * 处理快递100物流推送的信息
     * @param com      快递100中快递公司编码
     * @param postId   快递单号
     * @param state   快递单当前状态
     * @param condition 快递单明细状态标记
     * @param areaName 地区信息 省，市，区
     * @return boolean
     */
    Boolean dealKuaiDi100Status(String com, String postId, String state, String condition, String areaName);

    /**
     * 处理快递100物流推送的Abort
     * @param com      快递100中快递公司编码
     * @param postId   快递单号
     * @param condition 快递单明细状态标记
     * @return boolean
     */
    Boolean handlerKuaidi100AsAbort(String com, String postId, String condition);

}
