/**
 * Project Name:qiho-center-api
 * File Name:RemoteUrlService.java
 * Package Name:com.qiho.center.api.remoteservice
 * Date:2017年6月20日下午5:17:58
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteUrlService <br/>
 * 链接服务. <br/>
 * Date:     2017年6月20日 下午5:17:58 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteUrlService {

    /**
     * 根据短链接查询完整长链接地址
     *
     * @author zhanglihui
     * @param shortUrl
     * @return 长链接地址
     */
    DubboResult<String> getLongUrl(String shortUrl);
}

