package com.qiho.center.api.remoteservice.menu;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.menu.MenuDto;
import com.qiho.center.api.params.menu.MenuParams;

import java.util.List;

/**
 * 菜单API接口
 *
 * @author zhangshun
 * @version V1.0
 * @since 2017-12-07 16:13
 */
@AdvancedFeignClient
public interface RemoteMenuBackendService {

    /**
     * 初始化菜单
     *
     * @param
     * @return
     */
    Boolean initMenu();

    /**
     * 保存菜单
     *
     * @param menuDto
     * @return
     * @throws BizException
     */
    Long saveMenu(MenuDto menuDto) throws BizException;

    /**
     * 修改菜单
     *
     * @param menuDto
     * @return
     */
    Integer updateMenu(MenuDto menuDto) throws BizException;

    /**
     * ID 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id) throws BizException;

    /**
     * CODE 删除
     *
     * @param code
     * @return
     */
    Integer deleteByCode(String code) throws BizException;

    /**
     * 查询菜单
     *
     * @param menuParams
     * @return
     * @throws BizException
     */
    List<MenuDto> findByParam(MenuParams menuParams) throws BizException;

}
