package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.consumer.ConsumerOrderDto;

import java.util.List;

/**
 * 提供consumerId查询订单信息的服务
 * consuemerId组成规则：deviceId + appId（媒体id）
 */
@AdvancedFeignClient
public interface RemoteComsumerOrderService {

    /**
     * 查询最新的一个订单（一个月内）
     * 每次查询后更新redis里的订单访问标识
     * @param consumerId
     * @return
     */
    ConsumerOrderDto getLatestOrderByConsumerId(String consumerId);

    /**
     * 查询订单列表（一个月内）
     * @param consumerId
     * @return
     */
    List<ConsumerOrderDto> getOrderListByConsumerId(String consumerId);

    /**
     * 查询订单详情
     * @param orderId
     * @return
     */
    ConsumerOrderDto getOrderById(String orderId);

    /**
     * 查询百奇订单与虚拟商品订单
     * @param consumerId
     * @return
     */
    ConsumerOrderDto getLatestBaiqiAndVirtualOrder(String consumerId);

    /**
     * 查询百奇订单与虚拟商品订单
     * @param consumerId
     * @return
     */
    List<ConsumerOrderDto> listBaiqiAndVirtualOrder(String consumerId);
}
