package com.qiho.center.api.remoteservice.template;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.model.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.template.MerchantBlackDto;
import com.qiho.center.api.params.template.MerchantBlackPagingParam;
import com.qiho.center.api.params.template.MerchantBlackParam;

/**
 * @author Wangpf
 * @description 商家黑名单远程服务
 * @date 2020/2/11 11:51 AM
 */
@AdvancedFeignClient
public interface RemoteMerchantBlackService {

    /**
     * 新增短信模板商家黑名单
     *
     * @param merchantBlackListParam
     * @return
     */
    DubboResult save(MerchantBlackParam merchantBlackListParam);

    /**
     * 分页查询商家黑名单
     *
     * @param merchantBlackListPagingParam 分页查询参数
     * @return
     */
    PagenationDto<MerchantBlackDto> pageQuery(MerchantBlackPagingParam merchantBlackListPagingParam);

    /**
     * 删除当前商家黑名单
     *
     * @param id
     * @return
     */
    boolean delete(Long id);
}
