/**
 * Project Name:qiho-center-api File Name:FundOrderDto.java Package Name:com.qiho.center.api.dto
 * Date:2017年6月6日下午12:57:57 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import java.util.Date;

import com.qiho.center.api.enums.FundBizTypeEnum;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;

/**
 * ClassName:FundOrderDto <br/>
 * Date: 2017年6月6日 下午12:57:57 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class FundOrderDto extends BaseDto {

    /**
     */
    private static final long serialVersionUID = -4810010446285221894L;
    
    
    private Long			  id;

    /** 订单ID */
    private String            orderId;

    /** 资金流水ID */
    private String            fundId;

    /** 付款方式，{@link PayTypeEnum} */
    private String            payType;

    /** 账号 */
    private String            account;

    /** 发生额，单位：分 */
    private Integer           amt;

    /** 外部流水号 */
    private String            outSeqNo;

    /** 资金状态，{@link FundStatusEnum} */
    private String            fundStatus;

    /** 资金业务类型，{@link FundBizTypeEnum} */
    private String            bizType;

    /** 创建时间 */
    private Date              gmtCreate;

    /** 修改时间 */
    private Date              gmtModified;

    /** 售后子订单id */
    private String            aftersaleId;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * fundId.
     *
     * @return the fundId
     */
    public String getFundId() {
        return fundId;
    }

    /**
     * fundId.
     *
     * @param fundId the fundId to set
     */
    public void setFundId(String fundId) {
        this.fundId = fundId;
    }

    /**
     * payType.
     *
     * @return the payType
     */
    public String getPayType() {
        return payType;
    }

    /**
     * payType.
     *
     * @param payType the payType to set
     */
    public void setPayType(String payType) {
        this.payType = payType;
    }

    /**
     * account.
     *
     * @return the account
     */
    public String getAccount() {
        return account;
    }

    /**
     * account.
     *
     * @param account the account to set
     */
    public void setAccount(String account) {
        this.account = account;
    }

    /**
     * amt.
     *
     * @return the amt
     */
    public Integer getAmt() {
        return amt;
    }

    /**
     * amt.
     *
     * @param amt the amt to set
     */
    public void setAmt(Integer amt) {
        this.amt = amt;
    }

    /**
     * outSeqNo.
     *
     * @return the outSeqNo
     */
    public String getOutSeqNo() {
        return outSeqNo;
    }

    /**
     * outSeqNo.
     *
     * @param outSeqNo the outSeqNo to set
     */
    public void setOutSeqNo(String outSeqNo) {
        this.outSeqNo = outSeqNo;
    }

    /**
     * fundStatus.
     *
     * @return the fundStatus
     */
    public String getFundStatus() {
        return fundStatus;
    }

    /**
     * fundStatus.
     *
     * @param fundStatus the fundStatus to set
     */
    public void setFundStatus(String fundStatus) {
        this.fundStatus = fundStatus;
    }

    /**
     * bizType.
     *
     * @return the bizType
     */
    public String getBizType() {
        return bizType;
    }

    /**
     * bizType.
     *
     * @param bizType the bizType to set
     */
    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

    public String getAftersaleId() {
        return aftersaleId;
    }

    public void setAftersaleId(String aftersaleId) {
        this.aftersaleId = aftersaleId;
    }
}
