package com.qiho.center.api.dto.resultbase;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.ShotOrder.ShotOrderFieldEnum;
import org.slf4j.Logger;

import java.util.List;

/**
 * Created by danke on 2017/6/16.
 * 用于返回值及异常相关结果类
 */
public class ResultBase<T> extends BaseDto {

	private boolean isSuccess = false;  //标识校验过程是否成功
    private int errorCode = 0;
    private String errorMsg = "";
    private String warnMsg = "";
    private T value;
    private Integer total;
    private Integer num;
    private Integer index;
    private List<Integer> indexList;

    /**
     * 命中的踢单或下单规则字段枚举
     */
    private ShotOrderFieldEnum hitField;


    public ResultBase() {
        // Do nothing
    }

    public boolean hasSuccessValue() {
        return this.isSuccess && this.value != null;
    }

    public ResultBase<T> setRightReturn(T value) {
        this.isSuccess = true;
        this.value = value;
        return this;
    }

    public static <T> ResultBase<T> defaultReturn(T value){
        ResultBase<T> res = new ResultBase<>();
        res.isSuccess = true;
        res.value = value;
        return res;
    }

    public static <T> ResultBase<T> rightReturn(T value) {
        return (new ResultBase()).setRightReturn(value);
    }

    public ResultBase<T> setErrorReturn(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public static <T> ResultBase<T> errorReturn(String errorMsg) {
        return (new ResultBase()).setErrorReturn(errorMsg);
    }

    public ResultBase<T> setErrorReturn(String errorMsg, Logger log) {
        if (log != null) {
            log.error(errorMsg);
        }

        return this.setErrorReturn(errorMsg);
    }

    public static <T> ResultBase<T> errorReturn(String errorMsg, Logger log) {
        if (log != null) {
            log.error(errorMsg);
        }

        return errorReturn(errorMsg);
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public ResultBase<T> setErrorCode(int errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getWarnMsg() {
        return this.warnMsg;
    }

    public void setWarnMsg(String warnMsg) {
        this.warnMsg = warnMsg;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public Integer getNum() {
        return this.num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public List<Integer> getIndexList() {
        return this.indexList;
    }

    public void setIndexList(List<Integer> indexList) {
        this.indexList = indexList;
    }

    public ShotOrderFieldEnum getHitField() {
        return hitField;
    }

    public void setHitField(ShotOrderFieldEnum hitField) {
        this.hitField = hitField;
    }
}
