package com.qiho.center.api.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-06-21.
 */
public enum OrderCloseRemarkEnum {
    /**
     * 订单关闭的原因o
     */
    CUSTOMERSERVICE_AUDIT_REJECT("customerservice_audit_reject", "客服审核不通过"),
    CUSTOMERSERVICE_CANCEL_DELIVERY("customerservice_cancel_delivery", "客服取消发货"),
    CONSUMER_CANCEL_ORDER("consumer_cancel_order", "用户取消订单"),
    SHIELD_AUDIT_REJECT("shield_audit_reject", "风控规则审核不通过"),
    MERCHANT_AUDIT_REJECT("merchant_audit_reject", "商家审核不通过"),
    MERCHANT_CANCEL_DELIVERY("merchant_cancel_delivery", "商家取消发货"),
    BULLPOSITION_REJECT_SIGNFOR("bullposition_reject_signfor", "用户拒签");

    /**
     * 代码
     */
    private String code;

    /**
     * 描述
     */
    private String desc;

    private OrderCloseRemarkEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据code获取枚举值
     *
     * @param code
     * @return
     */
    public static OrderCloseRemarkEnum getByCode(String code) {
        for (OrderCloseRemarkEnum enumVal : OrderCloseRemarkEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     * 获取所有code的集合
     *
     * @param
     * @return
     */
    public static List<String> getCodeList() {
        List<String> codeList = new ArrayList<>();
        for (OrderCloseRemarkEnum enumVal : OrderCloseRemarkEnum.values()) {
            codeList.add(enumVal.code);
        }
        return codeList;
    }

    /**
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
