package com.qiho.center.api.enums.area;

import com.qiho.center.api.enums.area.code.*;

public enum AreaCodeEnum {
    PROVINCE_11("11",  AreaCodeBJEnum.CODE_110000),
    PROVINCE_12("12",  AreaCodeTJEnum.CODE_120000),
    PROVINCE_13("13",  AreaCodeHBEnum.CODE_130000),
    PROVINCE_14("14",  AreaCodeSXEnum.CODE_140000),
    PROVINCE_15("15",  AreaCodeNMGEnum.CODE_150000),
    PROVINCE_21("21",  AreaCodeLNEnum.CODE_210000),
    PROVINCE_22("22",  AreaCodeJNEnum.CODE_220000),
    PROVINCE_23("23",  AreaCodeHLJEnum.CODE_230000),
    PROVINCE_31("31",  AreaCodeSHEnum.CODE_310000),
    PROVINCE_32("32",  AreaCodeJSEnum.CODE_320000),
    PROVINCE_33("33",  AreaCodeZJEnum.CODE_330000),
    PROVINCE_34("34",  AreaCodeAHEnum.CODE_340000),
    PROVINCE_35("35",  AreaCodeFJEnum.CODE_350000),
    PROVINCE_36("36",  AreaCodeJXEnum.CODE_360000),
    PROVINCE_37("37",  AreaCodeSDEnum.CODE_370000),
    PROVINCE_41("41",  AreaCodeHNEnum.CODE_410000),
    PROVINCE_42("42",  AreaCodeHUBEnum.CODE_420000),
    PROVINCE_43("43",  AreaCodeHUNEnum.CODE_430000),
    PROVINCE_44("44",  AreaCodeGDEnum.CODE_440000),
    PROVINCE_45("45",  AreaCodeGXEnum.CODE_450000),
    PROVINCE_46("46",  AreaCodeHANEnum.CODE_460000),
    PROVINCE_50("50",  AreaCodeCQEnum.CODE_500000),
    PROVINCE_51("51",  AreaCodeSCEnum.CODE_510000),
    PROVINCE_52("52",  AreaCodeGUZEnum.CODE_520000),
    PROVINCE_53("53",  AreaCodeYNEnum.CODE_530000),
    PROVINCE_54("54",  AreaCodeXZEnum.CODE_540000),
    PROVINCE_61("61",  AreaCodeSHXEnum.CODE_610000),
    PROVINCE_62("62",  AreaCodeGSEnum.CODE_620000),
    PROVINCE_63("63",  AreaCodeQHEnum.CODE_630000),
    PROVINCE_64("64",  AreaCodeNXEnum.CODE_640000),
    PROVINCE_65("65",  AreaCodeXJEnum.CODE_650000),
    ;

    private String code;

    private AreaCodeEnumerable areaCodeEnumerable;

    AreaCodeEnum(String code,  AreaCodeEnumerable areaCodeEnumerable) {
        this.code = code;
        this.areaCodeEnumerable = areaCodeEnumerable;
    }

    public static AreaCodeEnum getByCode(String code){
        for (AreaCodeEnum value : values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }

    public AreaCodeEnumerable getAreaCodeEnumerable() {
        return areaCodeEnumerable;
    }
}
