package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeFJEnum implements AreaCodeEnumerable {
    CODE_350000("350000", "福建省"),
    CODE_350100("350100", "福建省福州市"),
    CODE_350101("350101", "福建省福州市市辖区"),
    CODE_350102("350102", "福建省福州市鼓楼区"),
    CODE_350103("350103", "福建省福州市台江区"),
    CODE_350104("350104", "福建省福州市仓山区"),
    CODE_350105("350105", "福建省福州市马尾区"),
    CODE_350111("350111", "福建省福州市晋安区"),
    CODE_350121("350121", "福建省福州市闽侯县"),
    CODE_350122("350122", "福建省福州市连江县"),
    CODE_350123("350123", "福建省福州市罗源县"),
    CODE_350124("350124", "福建省福州市闽清县"),
    CODE_350125("350125", "福建省福州市永泰县"),
    CODE_350128("350128", "福建省福州市平潭县"),
    CODE_350181("350181", "福建省福州市福清市"),
    CODE_350182("350182", "福建省福州市长乐市"),
    CODE_350200("350200", "福建省厦门市"),
    CODE_350201("350201", "福建省厦门市市辖区"),
    CODE_350202("350202", "福建省厦门市鼓浪屿区"),
    CODE_350203("350203", "福建省厦门市思明区"),
    CODE_350204("350204", "福建省厦门市开元区"),
    CODE_350205("350205", "福建省厦门市杏林区"),
    CODE_350206("350206", "福建省厦门市湖里区"),
    CODE_350211("350211", "福建省厦门市集美区"),
    CODE_350212("350212", "福建省厦门市同安区"),
    CODE_350300("350300", "福建省莆田市"),
    CODE_350301("350301", "福建省莆田市市辖区"),
    CODE_350302("350302", "福建省莆田市城厢区"),
    CODE_350303("350303", "福建省莆田市涵江区"),
    CODE_350321("350321", "福建省莆田市莆田县"),
    CODE_350322("350322", "福建省莆田市仙游县"),
    CODE_350400("350400", "福建省三明市"),
    CODE_350401("350401", "福建省三明市市辖区"),
    CODE_350402("350402", "福建省三明市梅列区"),
    CODE_350403("350403", "福建省三明市三元区"),
    CODE_350421("350421", "福建省三明市明溪县"),
    CODE_350423("350423", "福建省三明市清流县"),
    CODE_350424("350424", "福建省三明市宁化县"),
    CODE_350425("350425", "福建省三明市大田县"),
    CODE_350426("350426", "福建省三明市尤溪县"),
    CODE_350427("350427", "福建省三明市沙县"),
    CODE_350428("350428", "福建省三明市将乐县"),
    CODE_350429("350429", "福建省三明市泰宁县"),
    CODE_350430("350430", "福建省三明市建宁县"),
    CODE_350481("350481", "福建省三明市永安市"),
    CODE_350500("350500", "福建省泉州市"),
    CODE_350501("350501", "福建省泉州市市辖区"),
    CODE_350502("350502", "福建省泉州市鲤城区"),
    CODE_350503("350503", "福建省泉州市丰泽区"),
    CODE_350504("350504", "福建省泉州市洛江区"),
    CODE_350521("350521", "福建省泉州市惠安县"),
    CODE_350524("350524", "福建省泉州市安溪县"),
    CODE_350525("350525", "福建省泉州市永春县"),
    CODE_350526("350526", "福建省泉州市德化县"),
    CODE_350527("350527", "福建省泉州市金门县"),
    CODE_350581("350581", "福建省泉州市石狮市"),
    CODE_350582("350582", "福建省泉州市晋江市"),
    CODE_350583("350583", "福建省泉州市南安市"),
    CODE_350600("350600", "福建省漳州市"),
    CODE_350601("350601", "福建省漳州市市辖区"),
    CODE_350602("350602", "福建省漳州市芗城区"),
    CODE_350603("350603", "福建省漳州市龙文区"),
    CODE_350622("350622", "福建省漳州市云霄县"),
    CODE_350623("350623", "福建省漳州市漳浦县"),
    CODE_350624("350624", "福建省漳州市诏安县"),
    CODE_350625("350625", "福建省漳州市长泰县"),
    CODE_350626("350626", "福建省漳州市东山县"),
    CODE_350627("350627", "福建省漳州市南靖县"),
    CODE_350628("350628", "福建省漳州市平和县"),
    CODE_350629("350629", "福建省漳州市华安县"),
    CODE_350681("350681", "福建省漳州市龙海市"),
    CODE_350700("350700", "福建省南平市"),
    CODE_350701("350701", "福建省南平市市辖区"),
    CODE_350702("350702", "福建省南平市延平区"),
    CODE_350721("350721", "福建省南平市顺昌县"),
    CODE_350722("350722", "福建省南平市浦城县"),
    CODE_350723("350723", "福建省南平市光泽县"),
    CODE_350724("350724", "福建省南平市松溪县"),
    CODE_350725("350725", "福建省南平市政和县"),
    CODE_350781("350781", "福建省南平市邵武市"),
    CODE_350782("350782", "福建省南平市武夷山市"),
    CODE_350783("350783", "福建省南平市建瓯市"),
    CODE_350784("350784", "福建省南平市建阳市"),
    CODE_350800("350800", "福建省龙岩市"),
    CODE_350801("350801", "福建省龙岩市市辖区"),
    CODE_350802("350802", "福建省龙岩市新罗区"),
    CODE_350821("350821", "福建省龙岩市长汀县"),
    CODE_350822("350822", "福建省龙岩市永定县"),
    CODE_350823("350823", "福建省龙岩市上杭县"),
    CODE_350824("350824", "福建省龙岩市武平县"),
    CODE_350825("350825", "福建省龙岩市连城县"),
    CODE_350881("350881", "福建省龙岩市漳平市"),
    CODE_352200("352200", "福建省宁德地区"),
    CODE_352201("352201", "福建省宁德地区宁德市"),
    CODE_352202("352202", "福建省宁德地区福安市"),
    CODE_352203("352203", "福建省宁德地区福鼎市"),
    CODE_352225("352225", "福建省宁德地区霞浦县"),
    CODE_352227("352227", "福建省宁德地区古田县"),
    CODE_352228("352228", "福建省宁德地区屏南县"),
    CODE_352229("352229", "福建省宁德地区寿宁县"),
    CODE_352230("352230", "福建省宁德地区周宁县"),
    CODE_352231("352231", "福建省宁德地区柘荣县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeFJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
