package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeHUNEnum implements AreaCodeEnumerable {
    CODE_430000("430000", "湖南省"),
    CODE_430100("430100", "湖南省长沙市"),
    CODE_430101("430101", "湖南省长沙市市辖区"),
    CODE_430102("430102", "湖南省长沙市芙蓉区"),
    CODE_430103("430103", "湖南省长沙市天心区"),
    CODE_430104("430104", "湖南省长沙市岳麓区"),
    CODE_430105("430105", "湖南省长沙市开福区"),
    CODE_430111("430111", "湖南省长沙市雨花区"),
    CODE_430121("430121", "湖南省长沙市长沙县"),
    CODE_430122("430122", "湖南省长沙市望城县"),
    CODE_430124("430124", "湖南省长沙市宁乡县"),
    CODE_430181("430181", "湖南省长沙市浏阳市"),
    CODE_430200("430200", "湖南省株洲市"),
    CODE_430201("430201", "湖南省株洲市市辖区"),
    CODE_430202("430202", "湖南省株洲市荷塘区"),
    CODE_430203("430203", "湖南省株洲市芦淞区"),
    CODE_430204("430204", "湖南省株洲市石峰区"),
    CODE_430211("430211", "湖南省株洲市天元区"),
    CODE_430221("430221", "湖南省株洲市株洲县"),
    CODE_430223("430223", "湖南省株洲市攸县"),
    CODE_430224("430224", "湖南省株洲市茶陵县"),
    CODE_430225("430225", "湖南省株洲市炎陵县"),
    CODE_430281("430281", "湖南省株洲市醴陵市"),
    CODE_430300("430300", "湖南省湘潭市"),
    CODE_430301("430301", "湖南省湘潭市市辖区"),
    CODE_430302("430302", "湖南省湘潭市雨湖区"),
    CODE_430304("430304", "湖南省湘潭市岳塘区"),
    CODE_430321("430321", "湖南省湘潭市湘潭县"),
    CODE_430381("430381", "湖南省湘潭市湘乡市"),
    CODE_430382("430382", "湖南省湘潭市韶山市"),
    CODE_430400("430400", "湖南省衡阳市"),
    CODE_430401("430401", "湖南省衡阳市市辖区"),
    CODE_430402("430402", "湖南省衡阳市江东区"),
    CODE_430403("430403", "湖南省衡阳市城南区"),
    CODE_430404("430404", "湖南省衡阳市城北区"),
    CODE_430411("430411", "湖南省衡阳市郊区"),
    CODE_430412("430412", "湖南省衡阳市南岳区"),
    CODE_430421("430421", "湖南省衡阳市衡阳县"),
    CODE_430422("430422", "湖南省衡阳市衡南县"),
    CODE_430423("430423", "湖南省衡阳市衡山县"),
    CODE_430424("430424", "湖南省衡阳市衡东县"),
    CODE_430426("430426", "湖南省衡阳市祁东县"),
    CODE_430481("430481", "湖南省衡阳市耒阳市"),
    CODE_430482("430482", "湖南省衡阳市常宁市"),
    CODE_430500("430500", "湖南省邵阳市"),
    CODE_430501("430501", "湖南省邵阳市市辖区"),
    CODE_430502("430502", "湖南省邵阳市双清区"),
    CODE_430503("430503", "湖南省邵阳市大祥区"),
    CODE_430511("430511", "湖南省邵阳市北塔区"),
    CODE_430521("430521", "湖南省邵阳市邵东县"),
    CODE_430522("430522", "湖南省邵阳市新邵县"),
    CODE_430523("430523", "湖南省邵阳市邵阳县"),
    CODE_430524("430524", "湖南省邵阳市隆回县"),
    CODE_430525("430525", "湖南省邵阳市洞口县"),
    CODE_430527("430527", "湖南省邵阳市绥宁县"),
    CODE_430528("430528", "湖南省邵阳市新宁县"),
    CODE_430529("430529", "湖南省邵阳市城步苗族自治县"),
    CODE_430581("430581", "湖南省邵阳市武冈市"),
    CODE_430600("430600", "湖南省岳阳市"),
    CODE_430601("430601", "湖南省岳阳市市辖区"),
    CODE_430602("430602", "湖南省岳阳市岳阳楼区"),
    CODE_430603("430603", "湖南省岳阳市云溪区"),
    CODE_430611("430611", "湖南省岳阳市君山区"),
    CODE_430621("430621", "湖南省岳阳市岳阳县"),
    CODE_430623("430623", "湖南省岳阳市华容县"),
    CODE_430624("430624", "湖南省岳阳市湘阴县"),
    CODE_430626("430626", "湖南省岳阳市平江县"),
    CODE_430681("430681", "湖南省岳阳市汨罗市"),
    CODE_430682("430682", "湖南省岳阳市临湘市"),
    CODE_430700("430700", "湖南省常德市"),
    CODE_430701("430701", "湖南省常德市市辖区"),
    CODE_430702("430702", "湖南省常德市武陵区"),
    CODE_430703("430703", "湖南省常德市鼎城区"),
    CODE_430721("430721", "湖南省常德市安乡县"),
    CODE_430722("430722", "湖南省常德市汉寿县"),
    CODE_430723("430723", "湖南省常德市澧县"),
    CODE_430724("430724", "湖南省常德市临澧县"),
    CODE_430725("430725", "湖南省常德市桃源县"),
    CODE_430726("430726", "湖南省常德市石门县"),
    CODE_430781("430781", "湖南省常德市津市市"),
    CODE_430800("430800", "湖南省张家界市"),
    CODE_430801("430801", "湖南省张家界市市辖区"),
    CODE_430802("430802", "湖南省张家界市永定区"),
    CODE_430811("430811", "湖南省张家界市武陵源区"),
    CODE_430821("430821", "湖南省张家界市慈利县"),
    CODE_430822("430822", "湖南省张家界市桑植县"),
    CODE_430900("430900", "湖南省益阳市"),
    CODE_430901("430901", "湖南省益阳市市辖区"),
    CODE_430902("430902", "湖南省益阳市资阳区"),
    CODE_430903("430903", "湖南省益阳市赫山区"),
    CODE_430921("430921", "湖南省益阳市南县"),
    CODE_430922("430922", "湖南省益阳市桃江县"),
    CODE_430923("430923", "湖南省益阳市安化县"),
    CODE_430981("430981", "湖南省益阳市沅江市"),
    CODE_431000("431000", "湖南省郴州市"),
    CODE_431001("431001", "湖南省郴州市市辖区"),
    CODE_431002("431002", "湖南省郴州市北湖区"),
    CODE_431003("431003", "湖南省郴州市苏仙区"),
    CODE_431021("431021", "湖南省郴州市桂阳县"),
    CODE_431022("431022", "湖南省郴州市宜章县"),
    CODE_431023("431023", "湖南省郴州市永兴县"),
    CODE_431024("431024", "湖南省郴州市嘉禾县"),
    CODE_431025("431025", "湖南省郴州市临武县"),
    CODE_431026("431026", "湖南省郴州市汝城县"),
    CODE_431027("431027", "湖南省郴州市桂东县"),
    CODE_431028("431028", "湖南省郴州市安仁县"),
    CODE_431081("431081", "湖南省郴州市资兴市"),
    CODE_431100("431100", "湖南省永州市"),
    CODE_431101("431101", "湖南省永州市市辖区"),
    CODE_431102("431102", "湖南省永州市芝山区"),
    CODE_431103("431103", "湖南省永州市冷水滩区"),
    CODE_431121("431121", "湖南省永州市祁阳县"),
    CODE_431122("431122", "湖南省永州市东安县"),
    CODE_431123("431123", "湖南省永州市双牌县"),
    CODE_431124("431124", "湖南省永州市道县"),
    CODE_431125("431125", "湖南省永州市江永县"),
    CODE_431126("431126", "湖南省永州市宁远县"),
    CODE_431127("431127", "湖南省永州市蓝山县"),
    CODE_431128("431128", "湖南省永州市新田县"),
    CODE_431129("431129", "湖南省永州市江华瑶族自治县"),
    CODE_431200("431200", "湖南省怀化市"),
    CODE_431201("431201", "湖南省怀化市市辖区"),
    CODE_431202("431202", "湖南省怀化市鹤城区"),
    CODE_431221("431221", "湖南省怀化市中方县"),
    CODE_431222("431222", "湖南省怀化市沅陵县"),
    CODE_431223("431223", "湖南省怀化市辰溪县"),
    CODE_431224("431224", "湖南省怀化市溆浦县"),
    CODE_431225("431225", "湖南省怀化市会同县"),
    CODE_431226("431226", "湖南省怀化市麻阳苗族自治县"),
    CODE_431227("431227", "湖南省怀化市新晃侗族自治县"),
    CODE_431228("431228", "湖南省怀化市芷江侗族自治县"),
    CODE_431229("431229", "湖南省怀化市靖州苗族侗族自治县"),
    CODE_431230("431230", "湖南省怀化市通道侗族自治县"),
    CODE_431281("431281", "湖南省怀化市洪江市"),
    CODE_432500("432500", "湖南省娄底地区"),
    CODE_432501("432501", "湖南省娄底地区娄底市"),
    CODE_432502("432502", "湖南省娄底地区冷水江市"),
    CODE_432503("432503", "湖南省娄底地区涟源市"),
    CODE_432522("432522", "湖南省娄底地区双峰县"),
    CODE_432524("432524", "湖南省娄底地区新化县"),
    CODE_433000("433000", "湖南省怀化市"),
    CODE_433001("433001", "湖南省怀化市"),
    CODE_433100("433100", "湖南省湘西土家族苗族自治州"),
    CODE_433101("433101", "湖南省湘西土家族苗族自治州吉首市"),
    CODE_433122("433122", "湖南省湘西土家族苗族自治州泸溪县"),
    CODE_433123("433123", "湖南省湘西土家族苗族自治州凤凰县"),
    CODE_433124("433124", "湖南省湘西土家族苗族自治州花垣县"),
    CODE_433125("433125", "湖南省湘西土家族苗族自治州保靖县"),
    CODE_433126("433126", "湖南省湘西土家族苗族自治州古丈县"),
    CODE_433127("433127", "湖南省湘西土家族苗族自治州永顺县"),
    CODE_433130("433130", "湖南省湘西土家族苗族自治州龙山县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeHUNEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
