package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeLNEnum implements AreaCodeEnumerable {
    CODE_210000("210000", "辽宁省"),
    CODE_210100("210100", "辽宁省沈阳市"),
    CODE_210101("210101", "辽宁省沈阳市市辖区"),
    CODE_210102("210102", "辽宁省沈阳市和平区"),
    CODE_210103("210103", "辽宁省沈阳市沈河区"),
    CODE_210104("210104", "辽宁省沈阳市大东区"),
    CODE_210105("210105", "辽宁省沈阳市皇姑区"),
    CODE_210106("210106", "辽宁省沈阳市铁西区"),
    CODE_210111("210111", "辽宁省沈阳市苏家屯区"),
    CODE_210112("210112", "辽宁省沈阳市东陵区"),
    CODE_210113("210113", "辽宁省沈阳市新城子区"),
    CODE_210114("210114", "辽宁省沈阳市于洪区"),
    CODE_210122("210122", "辽宁省沈阳市辽中县"),
    CODE_210123("210123", "辽宁省沈阳市康平县"),
    CODE_210124("210124", "辽宁省沈阳市法库县"),
    CODE_210181("210181", "辽宁省沈阳市新民市"),
    CODE_210200("210200", "辽宁省大连市"),
    CODE_210201("210201", "辽宁省大连市市辖区"),
    CODE_210202("210202", "辽宁省大连市中山区"),
    CODE_210203("210203", "辽宁省大连市西岗区"),
    CODE_210204("210204", "辽宁省大连市沙河口区"),
    CODE_210211("210211", "辽宁省大连市甘井子区"),
    CODE_210212("210212", "辽宁省大连市旅顺口区"),
    CODE_210213("210213", "辽宁省大连市金州区"),
    CODE_210224("210224", "辽宁省大连市长海县"),
    CODE_210281("210281", "辽宁省大连市瓦房店市"),
    CODE_210282("210282", "辽宁省大连市普兰店市"),
    CODE_210283("210283", "辽宁省大连市庄河市"),
    CODE_210300("210300", "辽宁省鞍山市"),
    CODE_210301("210301", "辽宁省鞍山市市辖区"),
    CODE_210302("210302", "辽宁省鞍山市铁东区"),
    CODE_210303("210303", "辽宁省鞍山市铁西区"),
    CODE_210304("210304", "辽宁省鞍山市立山区"),
    CODE_210311("210311", "辽宁省鞍山市千山区"),
    CODE_210321("210321", "辽宁省鞍山市台安县"),
    CODE_210323("210323", "辽宁省鞍山市岫岩满族自治县"),
    CODE_210381("210381", "辽宁省鞍山市海城市"),
    CODE_210400("210400", "辽宁省抚顺市"),
    CODE_210401("210401", "辽宁省抚顺市市辖区"),
    CODE_210402("210402", "辽宁省抚顺市新抚区"),
    CODE_210403("210403", "辽宁省抚顺市露天区"),
    CODE_210404("210404", "辽宁省抚顺市望花区"),
    CODE_210411("210411", "辽宁省抚顺市顺城区"),
    CODE_210421("210421", "辽宁省抚顺市抚顺县"),
    CODE_210422("210422", "辽宁省抚顺市新宾满族自治县"),
    CODE_210423("210423", "辽宁省抚顺市清原满族自治县"),
    CODE_210500("210500", "辽宁省本溪市"),
    CODE_210501("210501", "辽宁省本溪市市辖区"),
    CODE_210502("210502", "辽宁省本溪市平山区"),
    CODE_210503("210503", "辽宁省本溪市溪湖区"),
    CODE_210504("210504", "辽宁省本溪市明山区"),
    CODE_210505("210505", "辽宁省本溪市南芬区"),
    CODE_210521("210521", "辽宁省本溪市本溪满族自治县"),
    CODE_210522("210522", "辽宁省本溪市桓仁满族自治县"),
    CODE_210600("210600", "辽宁省丹东市"),
    CODE_210601("210601", "辽宁省丹东市市辖区"),
    CODE_210602("210602", "辽宁省丹东市元宝区"),
    CODE_210603("210603", "辽宁省丹东市振兴区"),
    CODE_210604("210604", "辽宁省丹东市振安区"),
    CODE_210624("210624", "辽宁省丹东市宽甸满族自治县"),
    CODE_210681("210681", "辽宁省丹东市东港市"),
    CODE_210682("210682", "辽宁省丹东市凤城市"),
    CODE_210700("210700", "辽宁省锦州市"),
    CODE_210701("210701", "辽宁省锦州市市辖区"),
    CODE_210702("210702", "辽宁省锦州市古塔区"),
    CODE_210703("210703", "辽宁省锦州市凌河区"),
    CODE_210711("210711", "辽宁省锦州市太和区"),
    CODE_210726("210726", "辽宁省锦州市黑山县"),
    CODE_210727("210727", "辽宁省锦州市义县"),
    CODE_210781("210781", "辽宁省锦州市凌海市"),
    CODE_210782("210782", "辽宁省锦州市北宁市"),
    CODE_210800("210800", "辽宁省营口市"),
    CODE_210801("210801", "辽宁省营口市市辖区"),
    CODE_210802("210802", "辽宁省营口市站前区"),
    CODE_210803("210803", "辽宁省营口市西市区"),
    CODE_210804("210804", "辽宁省营口市鲅鱼圈区"),
    CODE_210811("210811", "辽宁省营口市老边区"),
    CODE_210881("210881", "辽宁省营口市盖州市"),
    CODE_210882("210882", "辽宁省营口市大石桥市"),
    CODE_210900("210900", "辽宁省阜新市"),
    CODE_210901("210901", "辽宁省阜新市市辖区"),
    CODE_210902("210902", "辽宁省阜新市海州区"),
    CODE_210903("210903", "辽宁省阜新市新邱区"),
    CODE_210904("210904", "辽宁省阜新市太平区"),
    CODE_210905("210905", "辽宁省阜新市清河门区"),
    CODE_210911("210911", "辽宁省阜新市细河区"),
    CODE_210921("210921", "辽宁省阜新市阜新蒙古族自治县"),
    CODE_210922("210922", "辽宁省阜新市彰武县"),
    CODE_211000("211000", "辽宁省辽阳市"),
    CODE_211001("211001", "辽宁省辽阳市市辖区"),
    CODE_211002("211002", "辽宁省辽阳市白塔区"),
    CODE_211003("211003", "辽宁省辽阳市文圣区"),
    CODE_211004("211004", "辽宁省辽阳市宏伟区"),
    CODE_211005("211005", "辽宁省辽阳市弓长岭区"),
    CODE_211011("211011", "辽宁省辽阳市太子河区"),
    CODE_211021("211021", "辽宁省辽阳市辽阳县"),
    CODE_211081("211081", "辽宁省辽阳市灯塔市"),
    CODE_211100("211100", "辽宁省盘锦市"),
    CODE_211101("211101", "辽宁省盘锦市市辖区"),
    CODE_211102("211102", "辽宁省盘锦市双台子区"),
    CODE_211103("211103", "辽宁省盘锦市兴隆台区"),
    CODE_211121("211121", "辽宁省盘锦市大洼县"),
    CODE_211122("211122", "辽宁省盘锦市盘山县"),
    CODE_211200("211200", "辽宁省铁岭市"),
    CODE_211201("211201", "辽宁省铁岭市市辖区"),
    CODE_211202("211202", "辽宁省铁岭市银州区"),
    CODE_211204("211204", "辽宁省铁岭市清河区"),
    CODE_211221("211221", "辽宁省铁岭市铁岭县"),
    CODE_211223("211223", "辽宁省铁岭市西丰县"),
    CODE_211224("211224", "辽宁省铁岭市昌图县"),
    CODE_211281("211281", "辽宁省铁岭市铁法市"),
    CODE_211282("211282", "辽宁省铁岭市开原市"),
    CODE_211300("211300", "辽宁省朝阳市"),
    CODE_211301("211301", "辽宁省朝阳市市辖区"),
    CODE_211302("211302", "辽宁省朝阳市双塔区"),
    CODE_211303("211303", "辽宁省朝阳市龙城区"),
    CODE_211321("211321", "辽宁省朝阳市朝阳县"),
    CODE_211322("211322", "辽宁省朝阳市建平县"),
    CODE_211324("211324", "辽宁省朝阳市喀喇沁左翼蒙古族自治县"),
    CODE_211381("211381", "辽宁省朝阳市北票市"),
    CODE_211382("211382", "辽宁省朝阳市凌源市"),
    CODE_211400("211400", "辽宁省葫芦岛市"),
    CODE_211401("211401", "辽宁省葫芦岛市市辖区"),
    CODE_211402("211402", "辽宁省葫芦岛市连山区"),
    CODE_211403("211403", "辽宁省葫芦岛市龙港区"),
    CODE_211404("211404", "辽宁省葫芦岛市南票区"),
    CODE_211421("211421", "辽宁省葫芦岛市绥中县"),
    CODE_211422("211422", "辽宁省葫芦岛市建昌县"),
    CODE_211481("211481", "辽宁省葫芦岛市兴城市"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeLNEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }

}
