package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeNMGEnum implements AreaCodeEnumerable {
    CODE_150000("150000", "内蒙古自治区"),
    CODE_150100("150100", "内蒙古自治区呼和浩特市"),
    CODE_150101("150101", "内蒙古自治区呼和浩特市市辖区"),
    CODE_150102("150102", "内蒙古自治区呼和浩特市新城区"),
    CODE_150103("150103", "内蒙古自治区呼和浩特市回民区"),
    CODE_150104("150104", "内蒙古自治区呼和浩特市玉泉区"),
    CODE_150105("150105", "内蒙古自治区呼和浩特市郊区"),
    CODE_150121("150121", "内蒙古自治区呼和浩特市土默特左旗"),
    CODE_150122("150122", "内蒙古自治区呼和浩特市托克托县"),
    CODE_150123("150123", "内蒙古自治区呼和浩特市和林格尔县"),
    CODE_150124("150124", "内蒙古自治区呼和浩特市清水河县"),
    CODE_150125("150125", "内蒙古自治区呼和浩特市武川县"),
    CODE_150200("150200", "内蒙古自治区包头市"),
    CODE_150201("150201", "内蒙古自治区包头市市辖区"),
    CODE_150202("150202", "内蒙古自治区包头市东河区"),
    CODE_150203("150203", "内蒙古自治区包头市昆都伦区"),
    CODE_150204("150204", "内蒙古自治区包头市青山区"),
    CODE_150205("150205", "内蒙古自治区包头市石拐矿区"),
    CODE_150206("150206", "内蒙古自治区包头市白云矿区"),
    CODE_150207("150207", "内蒙古自治区包头市郊区"),
    CODE_150221("150221", "内蒙古自治区包头市土默特右旗"),
    CODE_150222("150222", "内蒙古自治区包头市固阳县"),
    CODE_150223("150223", "内蒙古自治区包头市达尔罕茂明安联合旗"),
    CODE_150300("150300", "内蒙古自治区乌海市"),
    CODE_150301("150301", "内蒙古自治区乌海市市辖区"),
    CODE_150302("150302", "内蒙古自治区乌海市海勃湾区"),
    CODE_150303("150303", "内蒙古自治区乌海市海南区"),
    CODE_150304("150304", "内蒙古自治区乌海市乌达区"),
    CODE_150400("150400", "内蒙古自治区赤峰市"),
    CODE_150401("150401", "内蒙古自治区赤峰市市辖区"),
    CODE_150402("150402", "内蒙古自治区赤峰市红山区"),
    CODE_150403("150403", "内蒙古自治区赤峰市元宝山区"),
    CODE_150404("150404", "内蒙古自治区赤峰市松山区"),
    CODE_150421("150421", "内蒙古自治区赤峰市阿鲁科尔沁旗"),
    CODE_150422("150422", "内蒙古自治区赤峰市巴林左旗"),
    CODE_150423("150423", "内蒙古自治区赤峰市巴林右旗"),
    CODE_150424("150424", "内蒙古自治区赤峰市林西县"),
    CODE_150425("150425", "内蒙古自治区赤峰市克什克腾旗"),
    CODE_150426("150426", "内蒙古自治区赤峰市翁牛特旗"),
    CODE_150428("150428", "内蒙古自治区赤峰市喀喇沁旗"),
    CODE_150429("150429", "内蒙古自治区赤峰市宁城县"),
    CODE_150430("150430", "内蒙古自治区赤峰市敖汉旗"),
    CODE_152100("152100", "内蒙古自治区呼伦贝尔盟"),
    CODE_152101("152101", "内蒙古自治区呼伦贝尔盟海拉尔市"),
    CODE_152102("152102", "内蒙古自治区呼伦贝尔盟满洲里市"),
    CODE_152103("152103", "内蒙古自治区呼伦贝尔盟扎兰屯市"),
    CODE_152104("152104", "内蒙古自治区呼伦贝尔盟牙克石市"),
    CODE_152105("152105", "内蒙古自治区呼伦贝尔盟根河市"),
    CODE_152106("152106", "内蒙古自治区呼伦贝尔盟额尔古纳市"),
    CODE_152122("152122", "内蒙古自治区呼伦贝尔盟阿荣旗"),
    CODE_152123("152123", "内蒙古自治区呼伦贝尔盟莫力达瓦达斡尔族自治旗"),
    CODE_152127("152127", "内蒙古自治区呼伦贝尔盟鄂伦春自治旗"),
    CODE_152128("152128", "内蒙古自治区呼伦贝尔盟鄂温克族自治旗"),
    CODE_152129("152129", "内蒙古自治区呼伦贝尔盟新巴尔虎右旗"),
    CODE_152130("152130", "内蒙古自治区呼伦贝尔盟新巴尔虎左旗"),
    CODE_152131("152131", "内蒙古自治区呼伦贝尔盟陈巴尔虎旗"),
    CODE_152200("152200", "内蒙古自治区兴安盟"),
    CODE_152201("152201", "内蒙古自治区兴安盟乌兰浩特市"),
    CODE_152202("152202", "内蒙古自治区兴安盟阿尔山市"),
    CODE_152221("152221", "内蒙古自治区兴安盟科尔沁右翼前旗"),
    CODE_152222("152222", "内蒙古自治区兴安盟科尔沁右翼中旗"),
    CODE_152223("152223", "内蒙古自治区兴安盟扎赉特旗"),
    CODE_152224("152224", "内蒙古自治区兴安盟突泉县"),
    CODE_152300("152300", "内蒙古自治区哲里木盟"),
    CODE_152301("152301", "内蒙古自治区哲里木盟通辽市"),
    CODE_152302("152302", "内蒙古自治区哲里木盟霍林郭勒市"),
    CODE_152322("152322", "内蒙古自治区哲里木盟科尔沁左翼中旗"),
    CODE_152323("152323", "内蒙古自治区哲里木盟科尔沁左翼后旗"),
    CODE_152324("152324", "内蒙古自治区哲里木盟开鲁县"),
    CODE_152325("152325", "内蒙古自治区哲里木盟库伦旗"),
    CODE_152326("152326", "内蒙古自治区哲里木盟奈曼旗"),
    CODE_152327("152327", "内蒙古自治区哲里木盟扎鲁特旗"),
    CODE_152500("152500", "内蒙古自治区锡林郭勒盟"),
    CODE_152501("152501", "内蒙古自治区锡林郭勒盟二连浩特市"),
    CODE_152502("152502", "内蒙古自治区锡林郭勒盟锡林浩特市"),
    CODE_152522("152522", "内蒙古自治区锡林郭勒盟阿巴嘎旗"),
    CODE_152523("152523", "内蒙古自治区锡林郭勒盟苏尼特左旗"),
    CODE_152524("152524", "内蒙古自治区锡林郭勒盟苏尼特右旗"),
    CODE_152525("152525", "内蒙古自治区锡林郭勒盟东乌珠穆沁旗"),
    CODE_152526("152526", "内蒙古自治区锡林郭勒盟西乌珠穆沁旗"),
    CODE_152527("152527", "内蒙古自治区锡林郭勒盟太仆寺旗"),
    CODE_152528("152528", "内蒙古自治区锡林郭勒盟镶黄旗"),
    CODE_152529("152529", "内蒙古自治区锡林郭勒盟正镶白旗"),
    CODE_152530("152530", "内蒙古自治区锡林郭勒盟正蓝旗"),
    CODE_152531("152531", "内蒙古自治区锡林郭勒盟多伦县"),
    CODE_152600("152600", "内蒙古自治区乌兰察布盟"),
    CODE_152601("152601", "内蒙古自治区乌兰察布盟集宁市"),
    CODE_152602("152602", "内蒙古自治区乌兰察布盟丰镇市"),
    CODE_152624("152624", "内蒙古自治区乌兰察布盟卓资县"),
    CODE_152625("152625", "内蒙古自治区乌兰察布盟化德县"),
    CODE_152626("152626", "内蒙古自治区乌兰察布盟商都县"),
    CODE_152627("152627", "内蒙古自治区乌兰察布盟兴和县"),
    CODE_152629("152629", "内蒙古自治区乌兰察布盟凉城县"),
    CODE_152630("152630", "内蒙古自治区乌兰察布盟察哈尔右翼前旗"),
    CODE_152631("152631", "内蒙古自治区乌兰察布盟察哈尔右翼中旗"),
    CODE_152632("152632", "内蒙古自治区乌兰察布盟察哈尔右翼后旗"),
    CODE_152634("152634", "内蒙古自治区乌兰察布盟四子王旗"),
    CODE_152700("152700", "内蒙古自治区伊克昭盟"),
    CODE_152701("152701", "内蒙古自治区伊克昭盟东胜市"),
    CODE_152722("152722", "内蒙古自治区伊克昭盟达拉特旗"),
    CODE_152723("152723", "内蒙古自治区伊克昭盟准格尔旗"),
    CODE_152724("152724", "内蒙古自治区伊克昭盟鄂托克前旗"),
    CODE_152725("152725", "内蒙古自治区伊克昭盟鄂托克旗"),
    CODE_152726("152726", "内蒙古自治区伊克昭盟杭锦旗"),
    CODE_152727("152727", "内蒙古自治区伊克昭盟乌审旗"),
    CODE_152728("152728", "内蒙古自治区伊克昭盟伊金霍洛旗"),
    CODE_152800("152800", "内蒙古自治区巴彦淖尔盟"),
    CODE_152801("152801", "内蒙古自治区巴彦淖尔盟临河市"),
    CODE_152822("152822", "内蒙古自治区巴彦淖尔盟五原县"),
    CODE_152823("152823", "内蒙古自治区巴彦淖尔盟磴口县"),
    CODE_152824("152824", "内蒙古自治区巴彦淖尔盟乌拉特前旗"),
    CODE_152825("152825", "内蒙古自治区巴彦淖尔盟乌拉特中旗"),
    CODE_152826("152826", "内蒙古自治区巴彦淖尔盟乌拉特后旗"),
    CODE_152827("152827", "内蒙古自治区巴彦淖尔盟杭锦后旗"),
    CODE_152900("152900", "内蒙古自治区阿拉善盟"),
    CODE_152921("152921", "内蒙古自治区阿拉善盟阿拉善左旗"),
    CODE_152922("152922", "内蒙古自治区阿拉善盟阿拉善右旗"),
    CODE_152923("152923", "内蒙古自治区阿拉善盟额济纳旗"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeNMGEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
