package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeZJEnum implements AreaCodeEnumerable {
    CODE_330000("330000", "浙江省"),
    CODE_330100("330100", "浙江省杭州市"),
    CODE_330101("330101", "浙江省杭州市市辖区"),
    CODE_330102("330102", "浙江省杭州市上城区"),
    CODE_330103("330103", "浙江省杭州市下城区"),
    CODE_330104("330104", "浙江省杭州市江干区"),
    CODE_330105("330105", "浙江省杭州市拱墅区"),
    CODE_330106("330106", "浙江省杭州市西湖区"),
    CODE_330108("330108", "浙江省杭州市滨江区"),
    CODE_330122("330122", "浙江省杭州市桐庐县"),
    CODE_330127("330127", "浙江省杭州市淳安县"),
    CODE_330181("330181", "浙江省杭州市萧山市"),
    CODE_330182("330182", "浙江省杭州市建德市"),
    CODE_330183("330183", "浙江省杭州市富阳市"),
    CODE_330184("330184", "浙江省杭州市余杭市"),
    CODE_330185("330185", "浙江省杭州市临安市"),
    CODE_330200("330200", "浙江省宁波市"),
    CODE_330201("330201", "浙江省宁波市市辖区"),
    CODE_330203("330203", "浙江省宁波市海曙区"),
    CODE_330204("330204", "浙江省宁波市江东区"),
    CODE_330205("330205", "浙江省宁波市江北区"),
    CODE_330206("330206", "浙江省宁波市北仑区"),
    CODE_330211("330211", "浙江省宁波市镇海区"),
    CODE_330225("330225", "浙江省宁波市象山县"),
    CODE_330226("330226", "浙江省宁波市宁海县"),
    CODE_330227("330227", "浙江省宁波市鄞县"),
    CODE_330281("330281", "浙江省宁波市余姚市"),
    CODE_330282("330282", "浙江省宁波市慈溪市"),
    CODE_330283("330283", "浙江省宁波市奉化市"),
    CODE_330300("330300", "浙江省温州市"),
    CODE_330301("330301", "浙江省温州市市辖区"),
    CODE_330302("330302", "浙江省温州市鹿城区"),
    CODE_330303("330303", "浙江省温州市龙湾区"),
    CODE_330304("330304", "浙江省温州市瓯海区"),
    CODE_330322("330322", "浙江省温州市洞头县"),
    CODE_330324("330324", "浙江省温州市永嘉县"),
    CODE_330326("330326", "浙江省温州市平阳县"),
    CODE_330327("330327", "浙江省温州市苍南县"),
    CODE_330328("330328", "浙江省温州市文成县"),
    CODE_330329("330329", "浙江省温州市泰顺县"),
    CODE_330381("330381", "浙江省温州市瑞安市"),
    CODE_330382("330382", "浙江省温州市乐清市"),
    CODE_330400("330400", "浙江省嘉兴市"),
    CODE_330401("330401", "浙江省嘉兴市市辖区"),
    CODE_330402("330402", "浙江省嘉兴市秀城区"),
    CODE_330411("330411", "浙江省嘉兴市郊区"),
    CODE_330421("330421", "浙江省嘉兴市嘉善县"),
    CODE_330424("330424", "浙江省嘉兴市海盐县"),
    CODE_330481("330481", "浙江省嘉兴市海宁市"),
    CODE_330482("330482", "浙江省嘉兴市平湖市"),
    CODE_330483("330483", "浙江省嘉兴市桐乡市"),
    CODE_330500("330500", "浙江省湖州市"),
    CODE_330501("330501", "浙江省湖州市市辖区"),
    CODE_330521("330521", "浙江省湖州市德清县"),
    CODE_330522("330522", "浙江省湖州市长兴县"),
    CODE_330523("330523", "浙江省湖州市安吉县"),
    CODE_330600("330600", "浙江省绍兴市"),
    CODE_330601("330601", "浙江省绍兴市市辖区"),
    CODE_330602("330602", "浙江省绍兴市越城区"),
    CODE_330621("330621", "浙江省绍兴市绍兴县"),
    CODE_330624("330624", "浙江省绍兴市新昌县"),
    CODE_330681("330681", "浙江省绍兴市诸暨市"),
    CODE_330682("330682", "浙江省绍兴市上虞市"),
    CODE_330683("330683", "浙江省绍兴市嵊州市"),
    CODE_330700("330700", "浙江省金华市"),
    CODE_330701("330701", "浙江省金华市市辖区"),
    CODE_330702("330702", "浙江省金华市婺城区"),
    CODE_330721("330721", "浙江省金华市金华县"),
    CODE_330723("330723", "浙江省金华市武义县"),
    CODE_330726("330726", "浙江省金华市浦江县"),
    CODE_330727("330727", "浙江省金华市磐安县"),
    CODE_330781("330781", "浙江省金华市兰溪市"),
    CODE_330782("330782", "浙江省金华市义乌市"),
    CODE_330783("330783", "浙江省金华市东阳市"),
    CODE_330784("330784", "浙江省金华市永康市"),
    CODE_330800("330800", "浙江省衢州市"),
    CODE_330801("330801", "浙江省衢州市市辖区"),
    CODE_330802("330802", "浙江省衢州市柯城区"),
    CODE_330821("330821", "浙江省衢州市衢县"),
    CODE_330822("330822", "浙江省衢州市常山县"),
    CODE_330824("330824", "浙江省衢州市开化县"),
    CODE_330825("330825", "浙江省衢州市龙游县"),
    CODE_330881("330881", "浙江省衢州市江山市"),
    CODE_330900("330900", "浙江省舟山市"),
    CODE_330901("330901", "浙江省舟山市市辖区"),
    CODE_330902("330902", "浙江省舟山市定海区"),
    CODE_330903("330903", "浙江省舟山市普陀区"),
    CODE_330921("330921", "浙江省舟山市岱山县"),
    CODE_330922("330922", "浙江省舟山市嵊泗县"),
    CODE_331000("331000", "浙江省台州市"),
    CODE_331001("331001", "浙江省台州市市辖区"),
    CODE_331002("331002", "浙江省台州市椒江区"),
    CODE_331003("331003", "浙江省台州市黄岩区"),
    CODE_331004("331004", "浙江省台州市路桥区"),
    CODE_331021("331021", "浙江省台州市玉环县"),
    CODE_331022("331022", "浙江省台州市三门县"),
    CODE_331023("331023", "浙江省台州市天台县"),
    CODE_331024("331024", "浙江省台州市仙居县"),
    CODE_331081("331081", "浙江省台州市温岭市"),
    CODE_331082("331082", "浙江省台州市临海市"),
    CODE_332500("332500", "浙江省丽水地区"),
    CODE_332501("332501", "浙江省丽水地区丽水市"),
    CODE_332502("332502", "浙江省丽水地区龙泉市"),
    CODE_332522("332522", "浙江省丽水地区青田县"),
    CODE_332523("332523", "浙江省丽水地区云和县"),
    CODE_332525("332525", "浙江省丽水地区庆元县"),
    CODE_332526("332526", "浙江省丽水地区缙云县"),
    CODE_332527("332527", "浙江省丽水地区遂昌县"),
    CODE_332528("332528", "浙江省丽水地区松阳县"),
    CODE_332529("332529", "浙江省丽水地区景宁畲族自治县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeZJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
