package com.qiho.center.api.enums.domain;

import com.qiho.center.api.enums.bizlog.BizLogStatusEnum;

public enum DomainStatusEnum {
    VALID(0, "有效"),
    INVALID(1, "无效");

    DomainStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static BizLogStatusEnum getByCode(int code) {
        for (BizLogStatusEnum enumVal : BizLogStatusEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    private int code;

    private String desc;

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
