package com.qiho.center.api.enums.page;

import java.util.Arrays;

/**
 * @author peanut.huang
 * @date 2018/2/23.
 */
public enum PageTypeEnum {

    /** 新皮肤的商品详情页 */
    ITEM_DETAIL(1, "商品详情页"),

    ITEM_COLLECTION(2, "商品集合页"),

    /** 组件化的商品详情页 */
    COMPONENT_ITEM_DETAIL(3, "组件化的商品详情页"),

    /** 组件化的集合页 */
    COMPONENT_COLLECTION_PAGE(4, "组件化的集合页"),

    /**
     * 我的落地页
     */
    MY_LAND_PAGE(5,"我的落地页页")

    ;

    private int value;

    private String desc;

    PageTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static PageTypeEnum findByValue(int value){
        return Arrays.stream(PageTypeEnum.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
