package com.qiho.center.api.enums.qualification;

/**
 * @author Wangpf
 * @description 资质状态审核枚举类
 * @date 2020/8/7 10:40 上午
 */
public enum ShopQualificationAuditEnum {

    TO_AUDIT(0, "待审核"),

    AUDIT_PASS(1, "审核通过"),

    AUDIT_REJECT(-1, "审核拒绝");


    /**
     * 审核状态
     */
    private final int auditStatus;

    /**
     * 描述
     */
    private final String desc;

    ShopQualificationAuditEnum(int auditStatus, String desc) {
        this.auditStatus = auditStatus;
        this.desc = desc;
    }

    public int getAuditStatus() {
        return auditStatus;
    }

    public String getDesc() {
        return desc;
    }
}
