package com.qiho.center.api.enums.security;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/20 2:34 下午
 */
@AllArgsConstructor
@Getter
public enum SecurityFundOperateTypeEnum {

    PAYMENT(1, "缴纳"),
    DEDUCT(2, "扣除"),
    RETURN(3, "退还");

    private Integer type;

    private String desc;

    public static List<Integer> getTypeList() {
        List<Integer> typeList = new ArrayList<>();
        for(SecurityFundOperateTypeEnum type : SecurityFundOperateTypeEnum.values()) {
            typeList.add(type.getType());
        }
        return typeList;
    }

    public static String getDescByCode(Integer code) {
        for (SecurityFundOperateTypeEnum type : SecurityFundOperateTypeEnum.values()) {
            if (Objects.equals(type.getType(), code)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
