package com.qiho.center.api.params;

import java.io.Serializable;

import com.qiho.center.api.enums.QueryBlackListTypeEnum;

/**
 * ClassName: QueryStatisticsDayDto <br/>
 * Function: 黑名单批量操作. <br/>
 * date: 2017年6月20日 下午3:56:54 <br/>
 *
 * @author chencheng
 * @version
 */
public class BlackListOperationParams implements Serializable {

    private static final long      serialVersionUID = -7885331406663532696L;

    /** 删除数据 */
    public static final int        ADD_TYPE         = 1;
    /** 新增数据 */
    public static final int        DELETE_TYPE      = 0;

    /** 数据操作类型，1：新增，0删除 */
    private int                    dataType;

    /** 操作类型 {QueryBlackListTypeEnum} */
    private QueryBlackListTypeEnum type;

    /** 黑名单值 */
    private String                 bkValue;

    /** 备注 */
    private String                 remarks;

    /**
     * remarks.
     *
     * @return the remarks
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * remarks.
     *
     * @param remarks the remarks to set
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    /**
     * bkValue.
     *
     * @return the bkValue
     */
    public String getBkValue() {
        return bkValue;
    }

    /**
     * bkValue.
     *
     * @param bkValue the bkValue to set
     */
    public void setBkValue(String bkValue) {
        this.bkValue = bkValue;
    }

    /**
     * dataType.
     *
     * @return the dataType
     */
    public int getDataType() {
        return dataType;
    }

    /**
     * dataType.
     *
     * @param dataType the dataType to set
     */
    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    /**
     * type.
     *
     * @return the type
     */
    public QueryBlackListTypeEnum getType() {
        return type;
    }

    /**
     * type.
     *
     * @param type the type to set
     */
    public void setType(QueryBlackListTypeEnum type) {
        this.type = type;
    }

}
