package com.qiho.center.api.params;

import org.hibernate.validator.constraints.NotBlank;

/**
 * Created by jiafeng.geng on 2018/03/08.
 */
public class DeliveryRecordParams {

    /**
     * 商家id
     */
    @NotBlank
    private Long merchantId;

    /**
     * 物流公司编码
     */
    @NotBlank
    private String logisticsCode;

    /**
     * 批量审核的文件地址
     */
    @NotBlank
    private String fileUrl;

    /**
     * 原文件名称
     */
    @NotBlank
    private String originFileName;

    /**
     * 操作类型：1=批量发货、2=取消发货
     */
    @NotBlank
    private int recordType;

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getLogisticsCode() {
        return logisticsCode;
    }

    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getOriginFileName() {
        return originFileName;
    }

    public void setOriginFileName(String originFileName) {
        this.originFileName = originFileName;
    }

    public int getRecordType() {
        return recordType;
    }

    public void setRecordType(int recordType) {
        this.recordType = recordType;
    }

    @Override
    public String toString() {
        return "DeliveryRecordParams{" + "merchantId=" + merchantId + ", logisticsCode='" + logisticsCode + '\''
            + ", fileUrl='" + fileUrl + '\'' + ", originFileName='" + originFileName + '\'' + ", recordType="
            + recordType + '}';
    }
}
