package com.qiho.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.qiho.center.api.dto.ItemDto;

import java.util.List;

/**
 * Created by liuyao on 2017/5/23.
 * 商品推荐
 */
@AdvancedFeignClient
public interface RemoteRecommendItemService {

    /**
     * 批量推荐商品
     * @author zhanglihui
     * @param itemIds 商品ID列表
     * @return DubboResult
     */
    DubboResult<Void> recommendBatch(List<Long> itemIds);

    /**
     * 获取所有的推荐商品列表
     * @return
     */
    DubboResult<List<ItemDto>> findRecommendItemList();

    /**
     * 去除商品的推荐
     * @param itemId
     * @return
     */
    DubboResult<Boolean> deleteItemRecommend(Long itemId);

    /**
     *
     * @param itemIds
     * @return
     */
    DubboResult<Integer> sortItemRecommend(List<Long> itemIds);
    
    /**
     * 查询商城首页推荐商品列表
     *
     * @author zhanglihui
     * @return
     */
    DubboResult<List<ItemDto>> findRecommendIndex();

}
