package com.qiho.center.api.remoteservice.frontfile;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.frontfile.FrontFileDto;

import java.util.List;

/**
 * @author Wangpf
 * @description
 * @date 2020/6/30 1:56 下午
 */
@AdvancedFeignClient
public interface RemoteFrontFileService {

    /**
     * 获取所有的配置信息
     * @param env 环境标识
     * @return FrontFileDto
     */
    List<FrontFileDto> queryAll(String env);

    /**
     * 回滚某个key的某个版本
     *
     * @param fileKey 文件key
     * @param env 环境
     * @return 是否成功
     */
    boolean rollBackVersion(String fileKey, Long versionId, Long operatorId, String env);

    /**
     * 更新文件
     *
     * @param id
     * @param fileValue
     * @param operatorId
     * @return
     */
    boolean  updateFile(Long id,String fileValue,Long operatorId, String env);

}
